<?php

class Engineering extends Cf_Controller
{
    function __construct()
    {
        parent::__construct();

        setCurrentApplication('engineering');
    }

    function index($hostkey = null)
    {
        $this->load->model('host_model');
        $this->username = $this->session->userdata('username');
        $hostFound = $this->host_model->getHostFound($this->username,$hostkey);
        if ($hostFound === false)
        {
            $this->custom_404();
            return;
        }

        $requiredjs = array(
            array('host-page.js')
        );

        $this->carabiner->js($requiredjs);

        $requiredAngularjs = array(
            array('dist/angular-base.bundle.js'),

            array('hostInfo/app.js'),
            array('hostInfo/controllers/hostInfoController.js'),
            array('hubManagement/services/hubManagementService.js'),
            array('common_directives/objectsFilter.js'),

            array('dist/ace-editor.bundle.js'),
        );

        $this->carabiner->js($requiredAngularjs, $requiredAngularjs, $combine = true, $minify = false);



        $data = array(
            'title' => $this->lang->line('mission_portal_title') . " - " . $this->lang->line('hosts_app_page_title'),
            'hostkey' => $hostkey
        );

        $this->template->load('template', 'engineering', $data);
    }
}
