/*jslint node: true */
/*jslint browser: true*/
/*jslint nomen: true*/
/*global BaseController, angular, $*/

'use strict';

var alertsController = BaseController.extend({
    /**
     * Initialize  Controller
     * @param $scope, current controller scope
     */
    init: function ($scope, $location, $routeParams, $compile, $http, $q, $filter, autocompleteService, commonHelper, widgetHelper, dashboardHelper, alertsService, rulesService, modalWindowService, notificationService, widgetService, $timeout) {
        var self = this;
        this._super($scope);
        this.$location = $location;
        this.$compile = $compile;
        this.$http = $http;
        this._$q   = $q;
        self.$filter = $filter;
        this.$timeout = $timeout;

        this._autocompleteService = autocompleteService;
        this._notificationService = notificationService;
        this._commonHelper        = commonHelper;
        this._widgetHelper        = widgetHelper;
        this._dashboardHelper     = dashboardHelper;
        this._alertsService       = alertsService;
        this._rulesService        = rulesService;
        this._widgetService       = widgetService;
        this._$routeParams        = $routeParams;

        self.$scope.modalWindow  = modalWindowService;
        self.$scope.Math = Math;
        self.$scope.DCA  = DCA;

        // for inventory
        self.$scope.InventorySQL = {};
        self.$scope.InventoryUI  = {};
        self.$scope.applicationName = 'inventory_rule';

        // see invenory_data_addons
        self.$scope.CFE_Mapping_addFields    = CFE_Mapping_addFields;
        self.$scope.CFE_Mapping_removeFields = CFE_Mapping_removeFields;
        self.$scope.CFE_Mapping_addToFilters = CFE_Mapping_addToFilters;
        // ------------
        // inventory alert must have hostname selected.
        self.$scope.inventoryRuleDefaultColumns = inventoryRuleDefaultColumns;
        // ------------

        self.$scope.alerts      = []; // array of alerts - all alerts

        self.$scope.alertData   = {};
        self.$scope.alertData.customNotificationSelection = {};
        self.$scope.ruleData    = {};
        self.$scope.ruleData    = {};
        self.$scope.ruleData.customConditions = {};
        self.$scope.ruleData.customConditions.errors = [];
        self.$scope.customNotificationScriptsData = {};


        self.$scope.rulesList   = {};

        self.$scope.alertEvents = {};

        self.$scope.alertHosts  = [];

        self.$scope.widgetAlerts = {};
        self.$scope.widgetStats  = {};

        self.$scope.loadLimit   = {"hosts":10, "events":10};

        self.$scope.showFilter = true; // to show environment filter in alert edit view

        self.$scope.environment        = {};
        self.$scope.environment.name   = {};
        self.$scope.hostselectionstate = {};

        self.$scope.clickedAlert = true,

        self.$scope.userEditable = false;

        self.$scope.widgets = {};

        self.$scope.currentPage = 0;
        self.$scope.pageSize = 10;

        self.$scope.searchPlaceholder = "Search by alert or condition";

        self.$scope.currentDashboard = null;
        if (self._$routeParams.dashboard != undefined) {
            self.$scope.currentDashboard = self._$routeParams.dashboard;
        }

        // alerts or condition overview page
        if (self.$location.path().indexOf("listAll")!==-1) {
            self.$scope.getAllAlerts();
            self._getWidgetList();
            self._getRulesList();

            // find if user is the author of this dashboard
            self._dashboardHelper.getcurrentdashowner(self.$scope.currentDashboard).then(function(result){
                self.$scope.currentDashboard = result.dash;
                self.$scope.currentUser = result.username;
                self.$scope.userEditable = result.editable;
            });

            if (self.$location.hash().indexOf("widget=") > -1) {
                var widgetid = self.$location.hash().split('=');
                self._loadWidgetAndAlertsWithRuleData(widgetid[1]);
            }

            let queryParams = $location.search();
            if (queryParams.widget != undefined && queryParams.widget > 0) {
                self._loadWidgetAndAlertsWithRuleData(queryParams.widget);
            }
        }

         // show alertsByWidget page
        if (self._$routeParams.widgetId !== undefined  && self._$routeParams.action === undefined) {
           // If a widget view, load widget's data and all rules
           self._loadWidgetAndAlertsWithRuleData();
        }

        // alert result page
        if (self.$location.path().indexOf("alerts/result") !== - 1 && self._$routeParams.alertId !== undefined) {
            // find if user is the author of this dashboard
            self._dashboardHelper.getcurrentdashowner().then(function(result){
                self.$scope.currentUser = result.username;
                self.$scope.userEditable = result.editable;
            });
            self._getAlertData(self._$routeParams.alertId, true);
        }

        // add or edit for alert or condition
        if (self._$routeParams.action === 'add' || self._$routeParams.action === 'edit')
        {
            if (self.$location.path().indexOf("alerts") !== -1)
            {

                self._getRulesList();
                self._getNotificationsList();
                self._getNotificationsScripts();

                if (self._$routeParams.action === 'edit')
                {
                    self._getalerts(self._$routeParams.alertId).then(function(result) {
                        var alerts = result;
                        self.$scope.alertData = alerts[0];
                        self._getAlertRule(self.$scope.alertData.ruleid);
                        self._getAlertNotificationScripts(self.$scope.alertData);
                        self._loadWidgetAndAlertsWithRuleData(self.$scope.alertData.widgetid);
                        self.$scope.shownotifymail = self.$scope.alertData.emailToNotify ? true : false;
                        self.$scope.showreminder = self.$scope.alertData.reminder ? true : false;
                        var contextTmp = {};
                        contextTmp.profileId = self.$scope.alertData.hostContextsProfileId || '';
                        contextTmp.hostContextsPath = self.$scope.alertData.hostContextsPath || '';
                        contextTmp.hostContexts = self.$scope.alertData.hostContexts || '';
                        contextTmp.excludedHosts = self.$scope.alertData.excludedHosts || '';
                        self.$scope.hostselectionstate = contextTmp;
                    });
                } else if (self._$routeParams.action === 'add') {
                    self.$scope.widgetData = self._widgetService.getWidgetData();
                    if (self.$scope.widgetData.id) {
                        self._loadWidgetAndAlertsWithRuleData(self.$scope.widgetData.id);
                    }
                }
            }

        }

        // if widget id exists and action is alert adding then load this widget to add the new alert to it
        if (self._$routeParams.widgetId !== undefined  && self._$routeParams.action === 'add') {
            self._widgetHelper.getwidget(self._$routeParams.widgetId).then(
                function(widget) {
                    self.saveWidgetTmp(widget);
                    common.globalSpinner.hide();
                },
                function(error) {
                    self.$scope.$emit('loadWidgetAlert_Fail_Event', error.data);
                    common.globalSpinner.hide();
                });
        }
    },

    defineScope: function () {
        this.$scope.instance         = "alertsController";

        this.$scope.alertOrder       = this.alertOrder.bind(this);

        this.$scope.alert            = this.alert.bind(this);

        this.$scope.setPolicyConditionType        = this.setPolicyConditionType.bind(this);

        this.$scope.autocompleteList = this.autocompleteList.bind(this);
        this.$scope.autocompleteValidateValue = this.autocompleteValidateValue.bind(this);

        this.$scope.getAllAlerts        = this.getAllAlerts.bind(this);
        this.$scope.numberOfPages       = this.numberOfPages.bind(this);
        this.$scope.searchWidgets       = this.searchWidgets.bind(this);
        this.$scope.tabSelected         = this.tabSelected.bind(this);
        this.$scope.updateSearch        = this.updateSearch.bind(this);

        this.$scope.editAlert        = this.editAlert.bind(this);
        this.$scope.saveAlert        = this.saveAlert.bind(this);
        this.$scope.deleteRule       = this.deleteRule.bind(this);
        this.$scope.saveRule         = this.saveRule.bind(this);
        this.$scope.resumeAlert      = this.resumeAlert.bind(this);
        this.$scope.pauseAlert       = this.pauseAlert.bind(this);
        this.$scope.isAlertAlive     = this.isAlertAlive.bind(this);
        this.$scope.resetAlertData   = this.resetAlertData.bind(this);
        this.$scope.createWidget     = this.createWidget.bind(this);

        this.$scope.saveWidget       = this.saveWidget.bind(this);
        this.$scope.deleteWidget     = this.deleteWidget.bind(this);

        this.$scope.isEmptyObj       = this.isEmptyObj.bind(this);

        this.$scope.removeAlertFromWidget = this.removeAlertFromWidget.bind(this);

        this.$scope.severitySortFunction  = this.severitySortFunction.bind(this);
        this.$scope.selectedSortFunction  = this.selectedSortFunction.bind(this);

        this.$scope.clearEmail           = this.clearEmail.bind(this);
        this.$scope.validateFunction     = this.validateFunction.bind(this);

        this.$scope.numberOfAlertPages   = this.numberOfAlertPages.bind(this);
        this.$scope.setPageSize          = this.setPageSize.bind(this);
        this.$scope.setCurrentPage       = this.setCurrentPage.bind(this);

        this.$scope.convertStatus        = this.convertStatus.bind(this);

        this.$scope.prefillRuleName      = this.prefillRuleName.bind(this);

        this.$scope.loadNext             = this.loadNext.bind(this);
        this.$scope.saveWidgetTmp        = this.saveWidgetTmp.bind(this);
        this.$scope.viewWidgetInfo      = this.viewWidgetInfo.bind(this);

        this.$scope.validateCustomQuery = this.validateCustomQuery.bind(this);
        this.$scope.getHostName         = this.getHostName.bind(this);
        this.$scope.getHostLink         = this.getHostLink.bind(this);
        this.$scope.getHostKeyIndex         = this.getHostKeyIndex.bind(this);
    },

    defineListeners: function() {
      var self = this;

        self.$scope.$on("modalClose", function() {
            self.$scope.ruleData = {};
        });


        self.$scope.$on('environmentProfileChanged_Event', function(event, selectedProfile) {

            if (selectedProfile && selectedProfile.id)
            {
                self.$scope.alertData.hostContextsProfileId = selectedProfile.id;
            }
            else
            {
                self.$scope.alertData.hostContextsProfileId = '';
                self.$scope.alertData.hostContextsPath = '';
                self.$scope.alertData.hostContexts = selectedProfile;
            }
        });
        self.$scope.$on('environmentNodeChanged_Event', function(event, selectedNodes) {
            if (selectedNodes.length)
            {
                var nodePath = [];
                angular.forEach(selectedNodes, function(node, id) {
                    nodePath.push(node.label);
                });
                self.$scope.alertData.hostContextsPath = JSON.stringify(nodePath);
            }
            else {
                self.$scope.alertData.hostContextsPath = '';
            }
        });

        self.$scope.$on('environmentExcludeChanged_Event', function(event, excludedHosts) {

            if (Object.keys(excludedHosts).length)
            {
                self.$scope.alertData.excludedHosts = {name: Object.values(excludedHosts).join(', '), excludes: Object.keys(excludedHosts)};
            }
            else {
                self.$scope.alertData.excludedHosts = '';
            }
        });

        self.$scope.$on('environmentHostContextChange_Event', function(event, hostContextsObj) {
            if (hostContextsObj && !angular.equals({}, hostContextsObj))
            {
                self.$scope.alertData.hostContexts = hostContextsObj;
            }
            else {
                self.$scope.alertData.hostContexts = '';
            }
        });

        // watch environment for host filter form validation
        self.$scope.$watch('environment', function(newValue) {
            if (newValue.name && !angular.equals({}, newValue.name)) {
                self.$scope.environmentName = newValue.name;
            } else {
                self.$scope.environmentName = null;
            }
        }, true);

        self.$scope.$watch('ruleData', function(value) {
            if (!value) {
                self.$scope.ruleData = {};
            }
        }, true);

        //timeout of custom sql validation
        var validateTimeout;
        self.$scope.$watch('ruleData.customConditions.sql', function (sql) {
            if (sql == undefined) {
                return;
            }
            if (self.$scope.hasOwnProperty('ruleForm')) {
                self.$scope['ruleForm'].$valid = false;
            }

            if (validateTimeout) self.$timeout.cancel(validateTimeout);
            validateTimeout = self.$timeout(function() {
                self.$scope.validateCustomQuery()
            }.bind(self), 2000);
        }.bind(self))

        self.$scope.$watch('ruleData.id', function(value) {
            if (value && self.$scope.ruleData['type'] === 'inventory')  {
                self.$scope.InventorySQL = self.$scope.ruleData['inventoryConditions'];
            }
        }, true);

        self.$scope.$watch('conditionsActive', function(value) {
            if (value) {
                self.$scope.searchPlaceholder = "Search condition";
            }
        });

        self.$scope.$watch('ruleData.type', function (value) {
            switch (value) {
                case 'fileChanged':
                    if (self.$scope.ruleData.fileChangedConditions == undefined) {
                        self.$scope.ruleData.fileChangedConditions = {'condition': 'matches', 'timePeriod': 24};
                    }
                    break;
                case 'softwareupdate':
                    if (self.$scope.ruleData.softwareUpdateConditions == undefined) {
                        // set default software update condition
                        self.$scope.ruleData.softwareUpdateConditions = {'condition': 'is'};
                    } else if (self.$scope.ruleData.softwareUpdateConditions.condition == undefined) {
                        // set default software update condition in case of missing value in the database
                        self.$scope.ruleData.softwareUpdateConditions.condition = 'matches';
                    }
                    break;
            }
        });
    },

    saveWidgetTmp: function(widget) {
        var self = this;
        self.$scope.widgetData = widget || {};
        self._widgetService.saveWidgetData(self.$scope.widgetData);
    },

    numberOfPages: function(arrayLength) {
        return Math.ceil(arrayLength/this.$scope.pageSize);
    },

    getAllAlerts: function() {
        var self = this;
        common.globalSpinner.show();

        if (self.$location.hash()=='conditions') {
            self.$scope.conditionsActive = true;
        }

        self._getalerts().then(function(result) {
            self.$scope.alerts = result;
            self.$scope.filteredLength = result;
            common.globalSpinner.hide();
            if (self.$location.hash().indexOf("widget=") < 0 && self.$location.search().widget == undefined) {
                self.$scope.widgetData = self._widgetService.getWidgetData();
            }
        });
    },

    _getWidgetList: function() {
        var self = this;
        self._widgetHelper.getwidgetswithalerts(null, self.$scope.currentDashboard).then(
            function(result) {
                self.$scope.widgets = result;
                self.$scope.widgets = self.$scope.widgets.map(widget => {
                    widget.payload = JSON.parse(widget.payload);
                    return widget;
                })
            },
            function(error) {
                console.log("error");
            }
        );
    },

    clean: function(arrayCollection, deleteValue) {
        for (var i = 0; i < arrayCollection.length; i++) {
            if (arrayCollection[i] == deleteValue) {
                arrayCollection.splice(i, 1);
                i--;
            }
        }
        return arrayCollection;
    },

    searchWidgets: function(searchTerm) {
        // create an array of filtering both with individual widget, and all alerts filtered by name
        var self = this;
        var alertlist = [];
        if (!self.$scope.widgetData || !self.$scope.widgetData.id) {
            angular.copy(self.$scope.alerts, alertlist);
        } else {
            angular.forEach(self.$scope.alerts, function(value,key) {
                if (value.widgetid == self.$scope.widgetData.id) {
                    alertlist.push(value);
                }
            });
        }

        self.$scope.filteredLength = self.$filter('alertSearchFilter')(alertlist, self.$scope.searchTerm);
    },

    parseSearchTerm: function(searchTerm) {
        var self = this;
        var searchModel = {
            'name': []
        };

        var widget = [];

        var vars = searchTerm.split(/\s+/g);

        for (var i = 0; i < vars.length; i++) {
            var pair = vars[i].split(':');
            if (pair.length == 2) {
                var key = pair[0].trim();
                var value = pair[1].trim();
                if (key == 'widget' || key == 'type' || key == 'widgetId') {
                    var v = this.clean(value.split(','), '');
                    searchModel[key] = v;
                } else {
                    searchModel[key] = value;
                }
            } else {

                searchModel['name'].push(pair[0].trim());
            }

        }
        return searchModel;
    },

    tabSelected: function(tabname) {
        var self = this;
        if (!self.$scope.selectedTab) {
            self.$scope.selectedTab = true;
        } else {
            self.$location.hash(tabname);
        }
        // on tab switch make sure any alert messages are hidden
        self._notificationService.resetNotification();
    },

    updateSearch: function(term) {
        var self = this;
        if (self.$scope.clickedWidget == term) {
            term = '';
        }
        self.$scope.clickedWidget = term;
        self.$scope.searchWidgets(term);
    },


    editAlert: function (id) {
        var self = this, url = self.$location.path();
        if (id !== undefined) {
            url += '/edit/' + id;
        } else {
            url += '/add';
        }

        self.$location.path(url);
    },

    prefillRuleName: function(name) {
        // prefills condition name with alert name if new condition
        var self = this;
        if (name && !self.$scope.ruleData.name) {
            self.$scope.ruleData.name = name;
        }
    },

    isEmptyObj: function(obj) {
        return angular.equals({},obj);
    },

    deleteRule: function (id,idx) {

        /*
         * This should be to delete a rule from a list of rules.
         */
        var self = this;
        $("<div></div>")
            .dialog_modal({
                passedArgs: ["Are you sure you want to remove this condition? Doing so will also remove any alerts using this condition.", [
                    //buttons
                    {
                        "label":"Cancel",
                        "class":"btn-large"
                    },
                    {
                        "label":"Remove",
                        "class":"btn-large btn-primary btn-danger",
                        "callback": function(){
                            self._rulesService.deleterule(id).then(
                                function(result) {
                                    self._getRulesList();
                                    self._getalerts();
                                    self._getWidgetList();
                                    self.$scope.$emit('deleteRule_Success_Event');
                                    common.globalSpinner.hide();
                                },
                                function(error) {
                                    // TODO:
                                    // Error notification
                                    self.$scope.$emit('deleteRule_Fail_Event', error.data);
                                });
                        }
                    }
                ],
                    {
                        header:"<h2>Remove condition?</h2>"
                    }]
            });

    },

    saveRule: function() {
        var self = this;
        if (!self.$scope.alertData.ruleid && !angular.equals({}, self.$scope.ruleData))
        {
            if (self.$scope.ruleData['type'] === 'inventory') {
                self._refreshInventoryRuleData();
            }

            // create rule
            self._rulesService.saverule(self.$scope.ruleData).then(
                    function(result) {
                        self.$scope.$emit('saveRule_Success_Event', result.data );
                    },
                    function(error) {
                        self.$scope.$emit('saveRule_Fail_Event', error.data);
                    });
        }
    },

    alertFail: function (id) {
        var self = this;
        if (!self.$scope.alerts[id].paused) {
            if (self.$scope.alerts[id].fail > 0) {
                return true;
            } else {
                return false;
            }
        }
    },

    alertOrder: function(item) {
        if (item.paused) {
            return 3;
        }
        if (item.fails < 1) {
            return 2;
        }
        if (item.fails > 0) {
            return 1;
        }
    },

    alert: function(message) {
        bootbox.alert(message);
    },

    _getWidgetStats: function(alerts) {
        /*
         * USE THIS TO FETCH/CALCULATE USEFUL STATS FOR WIDGET ALERT LIST
         */
        var self = this;

        self.$scope.widgetStats = {"failingAlerts": 0,"passingAlerts":0};

        for (var i = 0; i < alerts.length; i++) {
            if (alerts[i].failHosts > 0) {
                self.$scope.widgetStats.failingAlerts = self.$scope.widgetStats.failingAlerts + 1;
            }

            else if (alerts[i].failHosts === 0 && alerts[i].totalHosts > 0) {
                self.$scope.widgetStats.passingAlerts = self.$scope.widgetStats.passingAlerts + 1;
            }
        }
    },

    setPolicyConditionType: function(value) {
        var self = this;
        self.$scope.ruleData.policyConditions = self.$scope.ruleData.policyConditions || {};
        self.$scope.ruleData.policyConditions.filterBy = value;

    },

    autocompleteList: function (listType, inputValue, inputParentType, inputParentValue) {
        var self = this;
        if (listType.toLowerCase() !== '') {
            return self._autocompleteService.load(listType.toLowerCase(), inputValue, inputParentType, inputParentValue);
        }
    },

    autocompleteValidateValue: function( $item, stringModelName) {
        var self = this;
        if ($item === 'No Match Found') {
            const nestedPropArr = stringModelName.split('.');
            const lastProperty = nestedPropArr.pop();
            let tmp = self.$scope;
            nestedPropArr.forEach(prop => {
                if (tmp[prop]) {
                    tmp = tmp[prop];
                }
            });
            if (tmp[lastProperty]) {
                tmp[lastProperty] = '';
            }
        }
    },

    saveAlert: function() {
        var self = this;

        if (self.$scope.ruleData['type'] === 'inventory') {
            self._refreshInventoryRuleData();
        }


        if (!self.$scope.alertData.ruleid && !angular.equals({}, self.$scope.ruleData))
        {

            // temp? remove filterby if no filteritemname
            if (self.$scope.ruleData.filterBy && !self.$scope.ruleData.filterItemName) {
                self.$scope.ruleData.filterBy = '';
            }

            // create rule
            self._rulesService.saverule(self.$scope.ruleData).then(
                    function(result) {
                      self.$scope.alertData.ruleid = result.data[0].ruleid;
                      self.$scope.$emit('saveRule_Success_Event', result.data);
                      self._savealert();
                    },
                    function(error) {
                // TODO:
                // Error notification
                    self.$scope.$emit('saveRule_Fail_Event', error.data);
            });
        } else if (self.$scope.alertData.ruleid) {
            self._savealert();
        }

    },


    /**
     * Inventry condition consist from SQL string which is created inside directive.
     * We must refresh sql string in directive and get it back in order to save inventory alert
     */
    _refreshInventoryRuleData: function() {
        var self = this;

        self.$scope.$broadcast('getInventoryAlertData_EVENT', self.$scope.inventoryRuleDefaultColumns);
        // note self.$scope.SQL object is "connected" to inventory directive
        self.$scope.ruleData['inventoryConditions'] = self.$scope.InventorySQL;
        self.$scope.$broadcast('updateVariablesDictionary_EVENT');
    },

    saveWidget: function(action) {
        var self = this;
        self.$scope.widgetData.dashboard = self.$scope.currentDashboard;
        self._widgetHelper.savewidget(self.$scope.widgetData).then(
            function(result) {
                var newwidget = true;
               // check for existing id - if none, then is new widget
                if (self.$scope.widgetData.id && !angular.equals([], self.$scope.widgetData.id)) {
                    newwidget = false;
                }
                self.$scope.widgetData.id = result.data[0].widgetId;
                self.$location.hash('');
                self.$location.path('alerts/listAll');
                self.$scope.$emit('saveWidget_Success_Event');

                // only do this if new widget
                if (newwidget) {
                    self._addWidgetToDash(self.$scope.widgetData.id);
                }
            },
            function(error) {

            if (action === 'create_widget') {
                // remove created alert, but keep condition
                if (self.$scope.widgetData.alerts[0]) {
                    self._alertsService.deletealert(self.$scope.widgetData.alerts[0]).then (
                            function(result){
                                return;
                            },
                            function(error){
                                self.$scope.$emit('deleteAlert_Fail_Event', error.data);
                            });
                }

            }

              self.$scope.$emit('saveWidget_Fail_Event', error.data);
        });
    },

    deleteWidget: function(widgetId) {
        var self = this;
        $("<div></div>")
            .dialog_modal({
                passedArgs: ["Remove this widget from the dashboard? All alerts in this widget will also be removed.", [
                    //buttons
                    {
                        "label": "Cancel",
                        "class": "btn-large"
                    },
                    {
                        "label": "Remove",
                        "class": "btn-large btn-primary btn-danger",
                        "callback": function () {
                            self._widgetHelper.deletewidget(widgetId).then(
                                function (result) {
                                    self._deleteWidgetFromDashes(widgetId);
                                    self._getWidgetList();
                                    self.$location.hash('');
                                },
                                function (error) {
                                    // error handled on helper level
                                }
                            );
                        }
                    }
                ],
                    {
                        header: "<h2>Remove widget?</h2>"
                    }],
            })
    },

    /**
     * Resume check
     *
     * @param {string} ruleId
     */
    resumeAlert: function(alert) {
        var self = this;
        common.globalSpinner.show();

        var alertsArray = [];
        if (alert) {
            alertsArray[0] = alert;
        } else {
            alertsArray = self.$scope.alerts;
        }

        angular.forEach(alertsArray, function(thisAlert, key) {
            self._alertsService.resumealert(thisAlert.id).then(
                function(result) {
                    self.$scope.$emit('saveAlert_Success_Event', result.data);
                    if (key >= alertsArray.length-1) {
                        if (self.$location.path().indexOf("alerts/result") !== - 1) {
                            self._getAlertData(self.$scope.alertData.id);
                            self._getAlertInfo();
                        } else {
                            self.$scope.getAllAlerts();
                        }
                        common.globalSpinner.hide();
                    }
                },
                function(error) {
                    common.globalSpinner.hide();
                    self.$scope.$emit('saveAlert_Fail_Event', error.data);
                });
        });
    },

    pauseAlert: function(alert, time) {
        var self = this;
        common.globalSpinner.show();
        var alertsArray = [];
        if (alert) {
            alertsArray[0] = alert;
        } else {

            // FIX THIS TO BE ONLY ALERTS IN CURRENT DASHBOARDS
            alertsArray = self.$scope.alerts;
        }

        angular.forEach(alertsArray, function(thisAlert, key) {
            self._alertsService.pausealert(thisAlert.id, time).then(
                function(result) {
                    self.$scope.$emit('saveAlert_Success_Event', result.data);
                      if (key >= alertsArray.length-1) {
                        if (self.$location.path().indexOf("alerts/result") !== - 1) {
                            self._getAlertData(self.$scope.alertData.id);
                            self._getAlertInfo();
                        } else {
                            self.$scope.getAllAlerts();
                        }
                        common.globalSpinner.hide();
                    }
                },
                function(error) {
                    common.globalSpinner.hide();
                    self.$scope.$emit('saveAlert_Fail_Event', error.data);
                });
        });
    },
    /**
     * Check if alert alive
     * if timestamp < now, or != -1 it is alive
     *
     * -1 means that alert is paused indefinitely
     *
     * @param {integer} timestamp
     */
    isAlertAlive: function(timestamp) {
        if (timestamp === -1) {
            return false;
        }

        if ((new Date().getTime()/1000)<timestamp ) {
            return true;
        } else {
            return false;
        }
    },

    _savealert:function() {
        var self = this;
        self._alertsService.savealert(self.$scope.alertData).then(
            function(result) {

                if (self._$routeParams.action === 'add')
                {
                    var id = result.data[0].alertId;

                    self.$scope.widgetData.alerts = self.$scope.widgetData.alerts || [];
                    self.$scope.widgetData.name = self.$scope.widgetData.name || self.$scope.alertData.name + "::widget";
                    self.$scope.widgetData.type = "alerts";
                    if (self.$scope.widgetData.hasOwnProperty('singleAlert') && self.$scope.widgetData.singleAlert) {
                        self.$scope.widgetData.payload = '{"singleAlert": true}';
                    }


                    self.$scope.widgetData.id = self.$scope.widgetData.id || [];
                    if ($.inArray(id, self.$scope.widgetData.alerts) === -1) {
                        self.$scope.widgetData.alerts.push(id);
                    }
                    self.saveWidget('create_widget');
                } else {
                    self._widgetService.saveWidgetData(self.$scope.widgetData);
                    self.$location.path('alerts/listAll');
                    self.$scope.$emit('saveAlert_Success_Event', result.data);
                }
            },
            function(error) {
                self.$scope.$emit('saveAlert_Fail_Event', error.data);
            });
    },

    _getalerts: function(alertid) {
        var self = this;
        var deferred = self._$q.defer();
        self._alertsService.getalertswithrule(alertid).then(
                function(result) {
                    deferred.resolve(result.data);
                },
                function(error) {
                    self.$scope.$emit('getAlert_Fail_Event', error.data);
                    return deferred.reject();
                });
        return  deferred.promise;
    },

    _loadWidgetAndAlertsWithRuleData: function(widgetId) {
        var self = this;
        if ($('#globalSpinner').is(':hidden')) {
            common.globalSpinner.show();
        }
        self._widgetHelper.loadWidgetAndAlertsWithRuleData(widgetId).then(
                function(result) {
                    self.$scope.widgetData   = result.widgetData;
                    self.$scope.widgetAlerts = result.widgetAlerts;
                    self._getWidgetStats(self.$scope.widgetAlerts);
                    common.globalSpinner.hide();
                },
                function(error) {
                    self.$scope.$emit('loadWidgetAlert_Fail_Event', error.data);
                    common.globalSpinner.hide();
                });
    },

    // TODO:
    // see removeAlert from widget in dashboard controller and try to refactor both
    removeAlertFromWidget: function(widgetId, alertid, alertname) {
        var self = this;
        var removeTxt = "Are you sure you want to remove alert \"" + alertname + "\" from this widget?";

        if (!widgetId || !alertid) {
            // TODO: Discuss notifications inside widget
            alert('Not all parameters set');
        }

        self._widgetHelper.getwidget(widgetId).then(
            function(result) {
                self.$scope.widgetData  = result;
                showDialog();
            },
            function(error) {
                var errorMsg = error.data;
                if (!errorMsg) {errorMsg = "There was a problem fetching widget data"};
                self.$scope.$emit('getSingleWidgetFail_Event', error.data);
            });


        function showDialog() {
            $("<div></div>")
                .dialog_modal({
                    passedArgs: [removeTxt, [
                        //buttons
                        {
                            "label":"Cancel",
                            "class":"btn-large"
                        },
                        {
                            "label":"Remove",
                            "class":"btn-large btn-primary btn-danger",
                            "callback": function() {
                                var widgetView = self._$routeParams.alertId ? false : true;
                                // check which view the user is currently in - overview or result view
                                if (self.$scope.widgetData.alerts.length===1) {
                                    self._widgetHelper.deletewidget(self.$scope.widgetData.id).then (
                                        function (result) {
                                            self.$scope.widgetData = {};
                                            widgetView ? self._getWidgetList() : self.$location.path('/alerts/listAll');
                                        },
                                        function (error) {
                                            // error handled on helper level
                                        }
                                    );
                                } else {
                                    self._alertsService.deletealert(alertid).then (
                                        function(result){
                                            self._getWidgetList();
                                            widgetView ? self.$scope.getAllAlerts() : self.$location.path('/alerts/listAll');
                                            self.$scope.$emit('deleteAlert_Success_Event');
                                        },
                                        function(error){
                                            self.$scope.$emit('deleteAlert_Fail_Event', error.data);
                                        });
                                }
                            }
                        },
                    ],
                        {
                            header:"<h1>Remove alert</h1>"
                        }],
                })


         };
    },
    /////////////////////////////////////
    resetAlertData: function(origin) {
        var self = this;
        var name;
        var params;

        self.$scope.alertEdit.$setPristine();

        // if from reset button, save name and id for continuing to edit
        if (origin) {
            if (self.$scope.alertData.id) {
                name = self.$scope.alertData.name;
            }

            params = {
                id:self.$scope.alertData.id,
                name:name,
                widgetid:self.$scope.alertData.widgetid,
                widgetName:self.$scope.alertData.widgetName
            };
        } else {
            // else clear after saving
            params = {
                widgetid:self.$scope.alertData.widgetid,
                widgetName:self.$scope.alertData.widgetName
            };
        }

        self.$scope.alertData   = {};
        self.$scope.ruleData    = {};
        self.$scope.environment = {};
        self.$scope.shownotify = false;

        self.$scope.$broadcast('clearing');

        self.$scope.alertData = params;
        self.$scope.clearEmail();
    },


    clearEmail: function () {
        var self = this;
        self.$scope.alertData.emailToNotify='';
        self.$scope.alertData.reminder=0;
        self.$scope.validation.$setPristine();
    },

    validateFunction: function () {

        var self = this;
        var valid = true;

        // temp fix for alert form validation OUTSIDE of wizard
        var forms = ['ruleForm', 'alertForm', 'validation'];
        for (var i=0;i<forms.length;i++) {
            if (self.$scope[forms[i]] && self.$scope[forms[i]].$invalid === true) {
                valid = false;
            }
        }

        return valid;
    },



    // pagination: refactor with events log pagination?
    setPageSize: function(size) {
        var self = this;
        self.$scope.pageSize = size;
        self.$scope.currentPage = 0;
    },

    setCurrentPage: function(num) {
        var self = this;
        self.$scope.currentPage=num;
    },

    // for event log
    numberOfAlertPages: function(arrayLength) {
        var num = 0;
        if (arrayLength) {
            num = Math.ceil(arrayLength/this.$scope.pageSize);
        }
        return new Array(num);
    },

    severitySortFunction: function(value) {
           if (value.severity === 'high') {
                return 0;
           }
           if (value.severity === 'medium') {
                return 1;
           }
           if (value.severity === 'low') {
                return 2;
           }
    },

    selectedSortFunction: function(value) {
        var self = this;

        if (self.$scope.alertData) {
            if (self.$scope.alertData.ruleid === value.id) {
                return 1;
            }
        } else {
            return 0;
        }
    },


    convertStatus: function(value) {
        // convert result strings such as NOTKEPT to more user friendly strings
        if (value==="NOTKEPT") {
            return ("Not kept");
        }
        else {
            return value;
        }
    },


    /**
     * Return info about alert events, rule and failed hosts
     *
     */
    _getAlertInfo: function() {
        var self = this;
            self._alertsService.getalertevents(self.$scope.alertData.id, self.$scope.loadLimit.events).then(
                    function(result) {
                        self.$scope.alertEvents = result.data;
                    },
                    function(error) {
                        self.$scope.$emit('getAlert_Fail_Event', error.data);
                    });

            self._getAlertRule(self.$scope.alertData.ruleid);

            // do not show host list for paused alerts
            if (self.$scope.alertData.paused !== 1) {
                common.globalSpinner.show();
                self._alertsService.getalerthosts(self.$scope.alertData.id, self.$scope.loadLimit.hosts).then(
                        function(result) {
                            self.$scope.alertHostsData = result.data;
                            common.globalSpinner.hide();
                        },
                        function(error) {
                            var errorMsg = error.data;
                            if (!error.data) {
                                errorMsg = "There was a problem retrieving the hosts";
                            }
                            self.$scope.$emit('alertHosts_Fail_Event', errorMsg);
                            common.globalSpinner.hide();
                        });
            }
    },

    /* single alert's data */
    _getAlertData: function(id, getWidget) {
        var self = this;
        self._getalerts(id).then(function(result) {
            var alerts = result;
            self.$scope.alertData = alerts[0];
            if (getWidget) {
                // if need widget data for alert's widget:
                self._widgetHelper.getwidget(self.$scope.alertData.widgetid).then(
                    function(result) {
                        self.$scope.widgetData = result;
                    },
                    function(error) {
                        // error handling
                    }
                );
            }
            self._getAlertInfo();
        });
    },

    _getRulesList: function() {
        var self = this;
        common.globalSpinner.show();
        self._rulesService.getrules().then(
                function(result) {
                    self.$scope.rulesList = result.data;
                    common.globalSpinner.hide();
                    if (!self.$scope.ruleData.id) {
                        self.$scope.ruleData = {}; // added this line to make sure chosen dropdown is updated in odd firefox bug
                    }
                },
                function(error) {
                    if (self.$location.path().indexOf("conditions") !== -1) {
                        self.$scope.$emit('alertRulesList_Fail_Event', error.data);
                    }
                    common.globalSpinner.hide();
                });
    },
    // TODO - return notification receiver groups
    _getNotificationsList: function() {
        return;
    },

    _getNotificationsScripts: function()
    {
        var self = this;
        var getScriptsSuccess = function(result)
        {
            self.$scope.customNotificationScriptsData = result.data;
        };

        var getScriptsFailure = function(error)
        {
            console.log("Error loading custom scripts",error);
        };

        self._alertsService.getAllScripts().then(
            getScriptsSuccess,
            getScriptsFailure
        );

    },

    _getAlertNotificationScripts: function (alert) {
       var self = this;
       self.$scope.alertData.customNotificationSelection = {};
       var success = function(result)
       {
           angular.forEach(result.data, function(value, key)
           {
               var id = value.id;
               self.$scope.alertData.customNotificationSelection[id] = true;
               self.$scope.shownotify = true;
           });

       };
       var error = function(error)
       {

            console.log("error loading scripts");
       }
       self._alertsService.getNotificationScriptForAlert(alert).then(success,error);

    },

    _getAlertRule: function(id) {
        var self = this;

        if (!id)
        {
            self.$scope.$emit('alertRuleGet_Fail_Event', 'Rule id is empty');
            return;
        }

        self._rulesService.getrules(id).then(
                function(result) {
                    self.$scope.ruleData = result.data[0];
                    if (self.$scope.ruleData['type'] === 'inventory')  {
                        self.$scope.InventorySQL = self.$scope.ruleData['inventoryConditions'];
                    }
                },
                function(error) {
                    self.$scope.$emit('alertRuleGet_Fail_Event', error.data);
                });
    },

    createWidget: function () {
        var self = this;
        self._widgetHelper.getwidgetwithname(self.$scope.widgetData.name, self.$scope.widgets).then(
            function (result) {
                if (result) {
                    //already exists
                    self.$scope.$emit('saveWidget_Fail_Event', "A widget with this name already exists");
                } else {
                    // save widgetdata and go to alert page
                    self._widgetService.saveWidgetData(self.$scope.widgetData);
                    self.$location.path('alerts/add');
                    self.$scope.modalWindow.close();
                }
            },
            function (error) {
                // error handled on helper level
            }
        );

    },

    loadNext: function(table) {
        var self = this;
        self.$scope.loadLimit[table] += 10;
        self._getAlertInfo();
    },

    viewWidgetInfo: function (widget) {
        var self = this;
        self._widgetService.saveWidgetData(widget);
        self.$location.path("alerts/listAll");
    },

    _addWidgetToDash: function (widget_id) {
        var self = this;
        // add to current user's selected dashboard
        return self._dashboardHelper.addwidget(widget_id).then(
            function(result) {

                return result;
            },
            function(error) {

            }
        );
    },

    _deleteWidgetFromDashes: function (widget_id) {
        var self = this;
        // remove FROM ANY DASHBOARD which has this widget
        return self._dashboardHelper.deletewidget(widget_id).then(
            function(result) {

                return result;
            },
            function(error) {

            }
        );
    },

    validateCustomQuery: function () {
        var self = this
        if(self.$scope.ruleData.customConditions == undefined){
            return;
        }
        var sql = this.$scope.ruleData.customConditions.sql;
        this._rulesService.validateCustomSql(sql).then(
            function(result) {
                self.$scope.ruleData.customConditions.errors = [];
                self.$scope['ruleForm'].$valid = true;
                result.data.forEach(function (value) {
                    self.$scope.ruleData.customConditions.errors.push(value);
                    self.$scope['ruleForm'].$valid = false;
                }.bind(self));
            }.bind(self),
            function(error) {
                self.$scope.$emit('deleteRule_Fail_Event', error.data);
            });

    },
    getHostName: function (item) {
        return item[0] == null ? 'Not discovered' : item[0];
    },
    getHostLink: function (item) {
        return item[0] == null ? '/hosts/' + item[this.getHostKeyIndex()] : '/assets/host_assets_by_name/' + item[0];
    }
    ,
    getHostKeyIndex: function () {
        var hostKeyIndex = 0;
         this.$scope.alertHostsData.hosts.header.forEach(function (value,index) {
            if(value.columnName == 'hostkey'){
                 hostKeyIndex = index;
            }
        })
        return hostKeyIndex;
    }

});

alertsController.$inject = [
                            '$scope',
                            '$location',
                            '$routeParams',
                            '$compile',
                            '$http',
                            '$q',
                            '$filter',
                            'autocompleteService',
                            'commonHelper',
                            'widgetHelper',
                            'dashboardHelper',
                            'alertsService',
                            'rulesService',
                            'modalWindowService',
                            'notificationService',
                            'widgetService',
                            '$timeout'
                        ];
window.alertsController = alertsController;
