<div class="contentWrapper">
	<div class="pageTitle">
		<h1>
			<span title="Created by: {{currentDash.username}}">
                <span ng-if="currentDash.username===currentUser"
                      editable-field
                      model="currentDash.name"
                      save-function="saveDashboardTitle()">
                    </span>
                <span ng-if="currentDash.username !== currentUser">{{ currentDash.name }}</span>
            </span>
            <div class="btn-group no-btn">
                <a data-toggle="dropdown" class="btn no-btn dropdown-toggle option-menu dashboard-dropdown">
                </a>
                <ul class="dashboard-dropdown dropdown-menu" ng-class="{'pull-right': !shortName, 'left': shortName}">
                    <li ng-show="public_dashboards.length">
                        <h4>Available dashboards</h4>
                    </li>
                    <li class="divider header" ng-show="public_dashboards.length"></li>
                    <li>
                        <table ng-show="public_dashboards.length" class="no-border shared-dashboards">
                            <thead>
                            <th></th>
                            <th class="no-padding"><span class="pull-right help-text margin-right-small created-by">Created by</span ></th>
                            <th></th>
                            </thead>
                            <tbody>
                            <tr ng-repeat="dash in public_dashboards = (dashboards | filter:{public: 1, username:'!'+currentUser} | orderBy:'name') track by $index">
                                <td class="dash-name">
                                    <a ng-click="selectDashboard(dash.id)">
                                        <div>{{dash.name}}</div>
                                    </a>
                                </td>
                                <td>
                                    <span class="pull-right help-text margin-right-small">{{dash.username || 'CFEngine'}}</span>
                                </td>
                                <td>
                                    <div class="dash-icons">
                                        <i  class="icon-copy"
                                            title="Make an editable copy"
                                            ng-click="cloneData(dash);modalWindow.open('cloneDashboard', this);$event.stopPropagation();">
                                        </i>
                                    </div>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </li>

                    <li ng-show="my_dashboards.length">
                        <h4>Your dashboards</h4>
                    </li>
                    <li class="divider header" ng-show="my_dashboards.length"></li>
                    <li class="dashboard-list-item" ng-repeat="dash in my_dashboards = ( dashboards | filter:{username: currentUser} | orderBy: 'name') track by $index">
                        <a class="flex flex--align_center" ng-click="selectDashboard(dash.id)">
                            <div class="inline-block dashname">
                                <span>{{dash.name}}</span>
                                <i ng-show="dash.public" class="icon-globe" style="margin-left:5px"></i>
                            </div>
                            <div class="dash-icons">
                                <i class="bi bi-pencil-fill" ng-click="copyData(dash);modalWindow.open('addDashboard', this);$event.stopPropagation();"></i>
                                <i class="bi bi-x" ng-click="copyData(dash);modalWindow.open('removeDashboard', this);$event.stopPropagation();"></i>
                            </div>
                        </a>
                    </li>
                    <li class="divider"></li>
                    <li><a ng-click="copyData({});isChecked = false;modalWindow.open('addDashboard', this)">Create new</a></li>
                </ul>
            </div>

            <div class="btn-group no-btn pull-right">
                <a data-toggle="dropdown" class="btn no-btn dropdown-toggle option-menu right">
                </a>
                <ul class="dropdown-menu pull-right">
                    <li ng-show="currentDash.username===currentUser"><a ng-click="modalWindow.open('addWidget', this)">Add new widget</a></li>
                    <li><a ng-href="/dashboard/conditions/add">Add new condition</a></li>
                    <li><a ng-href="/dashboard/alerts/listAll">View all alerts</a></li>
                    <li><a ng-href="/dashboard/eventlog">View full event log</a></li>
                    <li class="divider"></li>
                    <li><a class="CFE-context-help" data-key="dashboard" data-title="Dashboard"><i class="icon-question-sign margin-right-small"></i>Help</a></li>
                </ul>
            </div>
        </h1>
        <div class="alert inline-block" ng-if="noroles">
            The Dashboard is now empty, as this user has no roles assigned.
            Having a role is necessary to access any dashboards or data.
            Please contact a Mission Portal admin to assign your user account the appropriate roles.
        </div>
	</div>


    <!-- Main container div for dashboard content-->
    <div class="row-fluid float-left">
        <!-- Right sidebar -->
         <div id="dashboard-side">

            <div id="notifications">
                <div data-has-access="<?= isActionAllowed('audit-log.view') ? 'true' : 'false' ?>" class="auditLogEntryPoint margin-bottom-large"></div>
                <h2 class="inline-block"><a href="/dashboard/eventlog">Event log</a></h2>
                <ul class="unstyled">
                    <li ng-switch on="event.item_type" ng-repeat="event in eventsLog" class="margin-bottom-small">
                      <div ng-mouseenter="highlightWidgets(event.item_id)" ng-mouseleave="highlightWidgets()">
                        <a class="bold" ng-switch-when="alerts" ng-href="/dashboard/{{event.item_type}}/result/{{event.item_id}}">
                            {{event.message}}
                        </a>

                        <a class="bold" ng-switch-when="email" ng-href="/dashboard/eventlog#{{event.id}}">
                            {{event.message}}
                        </a>

                       <a class="bold" ng-switch-when="host" ng-href="/dashboard/eventlog#{{event.id}}">
                            {{event.message}}
                       </a>

                        <a class="bold upper-first" ng-switch-default ng-href="/dashboard/eventlog#{{event.id}}">
                            <span script-event></span>
                        </a>
                    </div>
                        <p class="muted" style="overflow:hidden;">
                            <span class="pull-left">{{event.time | convertTime}}</span>
                        </p>
                    </li>
                    <div ng-show="!eventsLog.length&&!eventsLogLoaded" class="dash-loading"><i class="icon icon-spinner icon-spin"></i></div>
                    <div ng-show="!eventsLog.length&&eventsLogLoaded">
                        <p>
                            <span class="muted">0 events in the log</span>
                        </p>
                        <a class="pull-left bold" ng-href="/dashboard/eventlog">View more</a>
                    </div>
                </ul>
            </div>
        </div>


        <!--
        //
        // Main widget area
        //
        -->
         <div id="dashboard-main">

            <ul class="sortable unstyled" ui-sortable="sortableWidgets" ng-model="widgets">
                <li ng-repeat="widget in widgets track by $index" ng-switch on="((widget.payload.hasOwnProperty('singleAlert') ? 'single_' : '') + widget.type)" class="widget-holder">

                    <div alert-widget refresh="{{refreshingTime}}"  ng-click="viewWidgetInfo(widget)" get-priority-numbers="getPriorityNumbers(widget.severityStat)" current-user="currentUser" current-dash="currentDash" widget="widget" widgetId="{{widget.id}}" delete-widget="deleteWidget(widget)" save-old-name="saveOldName(widget.name)" edit-name="editName(widget)" class="widget widget-small" ng-switch-when="alerts" ng-class="{true: 'hover'}[widget.isActive]"></div>

                    <div single-alert-widget refresh="{{refreshingTime}}"  ng-click="viewWidgetInfo(widget)" get-priority-numbers="getPriorityNumbers(widget.severityStat)" current-user="currentUser" current-dash="currentDash" widget="widget" widgetId="{{widget.id}}" delete-widget="deleteWidget(widget)" save-old-name="saveOldName(widget.name)" edit-name="editName(widget)" class="widget widget-small" ng-switch-when="single_alerts" ng-class="{true: 'hover'}[widget.isActive]"></div>

                    <div changes-widget <?= getWidgetStyles('container', 260, 458) ?> ng-click="goToChangesReport();" refresh="{{refreshingTime}}"  current-user="currentUser" current-dash="currentDash" widget="widget" widgetId="{{widget.id}}" delete-widget="deleteWidget(widget)" save-old-name="saveOldName(widget.name)" edit-name="editName(widget)" class="widget widget-medium" ng-switch-when="changes" ng-class="{true: 'hover'}[widget.isActive]"></div>

                    <div host-count-widget <?= getWidgetStyles('container', 260, 458) ?> ng-click="goToHostCountReport();" refresh="{{refreshingTime}}"  current-user="currentUser" current-dash="currentDash" widget="widget" widgetId="{{widget.id}}" delete-widget="deleteWidget(widget)" save-old-name="saveOldName(widget.name)" edit-name="editName(widget)" class="widget widget-medium hostTrend" ng-switch-when="hostCount" ng-class="{true: 'hover'}[widget.isActive]"></div>

                    <div inventory-widget <?= getWidgetStyles('container', 260, 458) ?> refresh="{{refreshingTime}}"  current-user="currentUser" current-dash="currentDash" widget="widget" widgetId="{{widget.id}}" delete-widget="deleteWidget(widget)" save-old-name="saveOldName(widget.name)" edit-name="editName(widget)" class="widget widget-medium" ng-switch-when="inventory" ng-class="{true: 'hover'}[widget.isActive]"></div>

                    <div decommissioned-host-widget <?= getWidgetStyles('container', 260, 458) ?> ng-click="goToEventsLog();" refresh="{{refreshingTime}}"  current-user="currentUser" current-dash="currentDash" widget="widget" widgetId="{{widget.id}}" delete-widget="deleteWidget(widget)" save-old-name="saveOldName(widget.name)" edit-name="editName(widget)" class="widget widget-medium decommissionedHostTrend" ng-switch-when="decommissionedHosts" ng-class="{true: 'hover'}[widget.isActive]"></div>

                    <div not-kept-widget <?= getWidgetStyles('container', 260, 458) ?> ng-click="goToNotKeptNotRepairedReport();" refresh="{{refreshingTime}}"  current-user="currentUser" current-dash="currentDash" widget="widget" widgetId="{{widget.id}}" delete-widget="deleteWidget(widget)" save-old-name="saveOldName(widget.name)" edit-name="editName(widget)" class="widget widget-medium notKeptCount" ng-switch-when="notKeptNeverRepaired" ng-class="{true: 'hover'}[widget.isActive]"></div>

                    <div file-changes-widget
                        <?= getWidgetStyles('container', 260, 458) ?>
                         ng-click="goToFileChangesReport();"
                         refresh="{{refreshingTime}}"
                         current-user="currentUser"
                         current-dash="currentDash"
                         widget="widget"
                         widgetId="{{widget.id}}"
                         delete-widget="deleteWidget(widget)"
                         save-old-name="saveOldName(widget.name)"
                         edit-name="editName(widget)"
                         class="widget widget-medium fileChangesWidget"
                         ng-switch-when="fileChanges"
                         ng-class="{true: 'hover'}[widget.isActive]">
                    </div>

                    <div compliance-widget
                        <?= getWidgetStyles('container', 260, 458) ?>
                         refresh="{{refreshingTime}}"
                         current-user="currentUser"
                         current-dash="currentDash"
                         widget="widget"
                         widgetId="{{widget.id}}"
                         delete-widget="deleteWidget(widget)"
                         save-old-name="saveOldName(widget.name)"
                         edit-name="editName(widget)"
                         class="widget widget-medium complianceWidget"
                         ng-switch-when="compliance"
                         ng-class="{true: 'hover'}[widget.isActive]">
                    </div>
                </li>
            </ul>
            <div ng-click="modalWindow.open('addWidget', this)" class="widget empty" ng-show="currentDash.username===currentUser">
                <p>
                    <a  class="btn btn-large btn-transparent"><i class="be bi-plus"></i> Add</a>
                </p>
            </div>
        </div>
    </div>
    <div style="clear:both"></div>
</div>

<div class="onboard-wizard"></div>
<div class="tour-guide"></div>
<license-reminder></license-reminder>

<?php
    $this->load->view('/partials/_addWidgetModal');
?>
<?php
    $this->load->view('/partials/_addDashboardModal');
?>
<?php
    $this->load->view('/partials/_removeDashboardModal');
?>

<?php
$this->load->view('/partials/cloneDashboardModal');
?>
