<?php
include_once __DIR__ . '/BaseLicenseModel.php';

class License_model extends Cf_Model implements BaseLicenseModel
{

    protected $rest = '';

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * @return CF_License
     * @throws Exception
     */
    public function getLicenseDetails() : CF_License
    {
        try
        {
            $apiInfo = $this->rest->get('/');
            $data = $this->checkData($apiInfo);
            if (is_array($data) && $this->hasErrors() == 0)
            {

                if (isset($data['data'][0]['license'])) {
                    return new CF_License($data['data'][0]['license']);
                }

            }
            else
            {
                throw new Exception($this->getErrorsString());
            }
        }
        catch (Exception $e)
        {
            log_message(log_level_for_exception($e), $e->getMessage() . " " . $e->getFile() . " line:" . $e->getLine());
            throw $e;
        }
    }
}
