import React from 'react';
import { createRoot } from 'react-dom/client';
import { BrowserRouter, Route, Routes } from 'react-router-dom';

import createCache from '@emotion/cache';
import { CacheProvider } from '@emotion/react';

import Complete from '../components/Setup/pages/Complete';
import ValidateCode from '../components/Setup/pages/ValidateCode';
import { ThemeListener } from '../components/ThemeListener/ThemeListener';
import '../styles.scss';

const root = createRoot(document.getElementById('setup-root') as HTMLElement);
const cache = createCache({ key: 'mui', prepend: true });
root.render(
  <React.StrictMode>
    <CacheProvider value={cache}>
      <BrowserRouter basename="/setup">
        <ThemeListener>
          <Routes>
            <Route path="/" element={<ValidateCode />} />
            <Route path="/complete" element={<Complete />} />
          </Routes>
        </ThemeListener>
      </BrowserRouter>
    </CacheProvider>
  </React.StrictMode>
);
