'use strict';

var sharedGroupsServiceClass = Class.extend({
    SHARED_GROUP_URL: MP_SITE_URL + '/groups_app/sharedGroups',

    create: function (data) {
        return this.$http.post(this.SHARED_GROUP_URL + '/group', data, {cache: false});
    },

    update: function (id, data) {
        return this.$http.put(`${this.SHARED_GROUP_URL}/group/${id}`, data, {cache: false});
    },

    remove: function (id) {
        return this.$http.delete(`${this.SHARED_GROUP_URL}/group/${id}`, {cache: false});
    },

    addGroup: function () {
        return this.$http.post(`${this.SHARED_GROUP_URL}/new_group`, [], {cache: false});
    },

    get: function (id) {
        return this.$http.get(`${this.SHARED_GROUP_URL}/group/${id}`, {cache: false});
    },

    list: function (params) {
        return this.$http.get(`${this.SHARED_GROUP_URL}/list?${params}`, {cache: false});
    },

    makePersonal: function (id) {
        return this.$http.post(`${this.SHARED_GROUP_URL}/makePersonal/${id}`, {cache: false});
    },

    addToFavorites: function (id) {
        return this.$http.post(`${this.SHARED_GROUP_URL}/favorite/${id}`, {cache: false});
    },

    removeFromFavorites: function (id) {
        return this.$http.delete(`${this.SHARED_GROUP_URL}/favorite/${id}`, {cache: false});
    },
});

(function () {
    const sharedGroupsServiceClassProvider = Class.extend({
        instance: new sharedGroupsServiceClass(),
        $get: ['$http',
            function ($http) {
                this.instance.$http = $http;
                return this.instance;
        }]
    });

    angular.module('sharedGroupsServiceModule', []).provider('sharedGroupsService', sharedGroupsServiceClassProvider);
}());
