<?php

class SettingsMailExporter extends BaseDataExporter
{
    public function isOnlyForAdmin(): bool
    {
        return true;
    }

    public function getData(): array
    {
        $data = $this->db->query("SELECT * FROM mail_settings")->result_array();
        $data = serialize($data);
        $encryptedData = $this->ci->cf_encrypt->encryptByKey($data, $this->encryptionKey);

        return ['data' => $encryptedData, 'info' => 'yes'];
    }
}
