<?php

class Build extends Cf_Controller
{

    public function __construct()
    {
        parent::__construct();
        setCurrentApplication('build_app');
    }

    public function index()
    {
        $requiredcss = [
            ['../../../themes/default/css/angularjs-ui/angular-ui.css']
        ];

        $this->carabiner->css($requiredcss);

        $requiredAngularjs = [
            ['dist/angular-base.bundle.js']
        ];

        $requiredjs = [
            ['buildApp/constants.js'],
            ['buildApp/app.js'],
            ['buildApp/controllers/baseBuildController.js'],
            ['buildApp/controllers/projectsController.js'],
            ['buildApp/controllers/modulesListController.js'],
            ['buildApp/controllers/modulesPageController.js'],
            ['buildApp/services/projectsService.js'],
            ['buildApp/services/modulesService.js'],
            ['buildApp/services/sshKeyService.js'],
            ['buildApp/services/masterfilesVersionService.js'],
            ['hostInfo/services/cmdbService.js'],
            ['hubManagement/services/hubManagementService.js'],
            ['common_directives/actions/actionService.js'],
            ['buildApp/directives/moduleData.js'],
        ];

        $this->carabiner->js($requiredAngularjs, $requiredAngularjs, $combine = true, $minify = false);
        $this->carabiner->js($requiredjs, $requiredjs, $combine = true, $minify = true);

        $data = ['title' => 'Mission Portal - Build'];

        $this->load->model('ProfileModel');
        $this->ProfileModel->setAdditionalData($this->session->userdata('username'), ProfileModel::BUILD_APP_OPENED_KEY, true);

        if (isInternetConnectionAvailable()) {
            $this->template->load('template', 'build_app/index', $data);
        } else {
            $this->template->load('template', 'build_app/network_error', $data);
        }
    }

    public function partials($dir, $partial)
    {
        $view = addslashes($dir) . '/' . addslashes($partial) . '.php';
        $this->load->view($view);
    }
}
