<?php

class PolicyConditionSetter extends BaseComplianceSetter
{
    public function setCondition(array &$condition, array $data = [])
    {
        $rule = $condition['rules'];
        if (!isset($rule['promise-status'])) {
            throw new Exception("Policy condition `{$condition['name']}` is missing rule's promise status");
        }
        $condition['policyConditions'] = [
            'filterBy' => $rule['filter-by'],
            'filterItemName' => $rule['value'],
            'promisehandle' => $rule['promise-handle'],
            'promiseoutcome' => $rule['promise-status'],
        ];
    }
}
