import React, { useMemo } from 'react';
import {
  Box,
  Typography
} from '@mui/material';

import { CmdbItem } from '../../../store/cmdbSlice/thunks';
import { POLICY_TYPES } from './Create';
import { getPolicyId } from 'src/components/Cmdb/utils';
interface PolicyConfigurationViewProps {
  item: CmdbItem;
  onValueClick?: () => void;
  classes?: Record<string, string>;
}

const PolicyConfigurationView: React.FC<PolicyConfigurationViewProps> = ({ 
  item, 
  onValueClick = () => {}, 
  classes = {} 
}) => {

    const selectedType = useMemo(() => {
      const policyId = getPolicyId(item);
      return POLICY_TYPES.find(type => type.id === policyId);
    }, [item]);
  
    const ViewValue = useMemo(() => {
      if (!selectedType || !selectedType.hasOwnProperty('viewComponent')) return null;
      const value = selectedType.getValueFromSubEntries(item.entries);
      return selectedType.viewComponent({ onValueClick, classes, value });
    }, [selectedType, item]);

  return (
    <>
      <Box className={classes.container}>
        <Typography className={classes.key}>
          Name:
        </Typography>
        <Box onClick={onValueClick} className={classes.value}>
          {item.name}
        </Box>
      </Box>
      {ViewValue}
      <Box className={classes.container}>
        <Typography className={classes.key}>
          Description:
        </Typography>
        <Box onClick={onValueClick} className={classes.value}>
          {item.description}
        </Box>
      </Box>
    </>
  );
};

export default PolicyConfigurationView;
