<?php

const AUDIT_LOG_TYPE_SETTINGS = 'Settings';
const AUDIT_LOG_TYPE_ROLE = 'Role';
const AUDIT_LOG_TYPE_USER = 'User';
const AUDIT_LOG_ACTION_UPDATE = 'Updated';
const AUDIT_LOG_ACTION_CREATE = 'Created';
const AUDIT_LOG_MAIL_SETTINGS_NAME = 'Mail';
const AUDIT_LOG_AUTHENTICATION_SETTINGS_NAME = 'Authentication';
const AUDIT_LOG_PREFERENCE_SETTINGS_NAME = 'Preference';
const AUDIT_LOG_VCS_SETTINGS_NAME = 'VCS';

if (!function_exists('log_audit')) {
    function log_audit(string $actor, string $objectType, string $action, string $objectId = null, string $objectName = null, array $details = [])
    {
        $auditLogsBridgePath = FCPATH . '/api/modules/auditLog/autoload-no-controllers.php';
        if (file_exists($auditLogsBridgePath) &&
            (include_once $auditLogsBridgePath) &&
            class_exists('AuditLogService')) {
            AuditLogService::register([
                AuditLogFields::ACTOR => $actor,
                AuditLogFields::OBJECT_TYPE => $objectType,
                AuditLogFields::OBJECT_ID => $objectId,
                AuditLogFields::OBJECT_NAME => $objectName,
                AuditLogFields::ACTION => $action,
                AuditLogFields::DETAILS => $details
            ]);
        } else {
            log_message('error', 'Audit log service is not loaded.');
        }
    }
}

if (!function_exists('deduct_credentials')) {
    function deduct_credentials(array $data, array $keysToDeduct = [], string $replacement = '*****') : array
    {
        foreach ($data as $key => $value) {
            if (in_array($key, $keysToDeduct)) {
                $data[$key] = $replacement;
            }
        }
        
        return $data;
    }
}
