<?php

/**
 * Class Not_kept_promises_model
 */
class Not_kept_promises_model extends Cf_Model
{
    private $from;
    private $to;

    const DEFAULT_PERIOD = 'week';

    /**
     * @var array
     */
    private static $periodsMap = [
        'day' => ['postgresFormat' => 'dd Mon yyyy', 'phpFormat' => 'd M Y'],
        'week' => ['postgresFormat' => '"Week #"WW yyyy', 'phpFormat' => '\W\e\e\k #W Y'],
        'month' => ['postgresFormat' => 'Mon yyyy', 'phpFormat' => 'M Y'],
        'year' => ['postgresFormat' => 'yyyy', 'phpFormat' => 'Y'],
    ];

    /**
     * @param $from
     * @param $to
     * @param string $period
     *
     * @return array
     */
    public function getNotKeptCount($from, $to, $username)
    {
        $this->from = $from;
        $this->to = $to;

        $escapedFrom = $this->db->escape_str($from);
        $escapedTo = $this->db->escape_str($to);

        $data = $this->advancedreports_model->runQuery(
            $username,
            "SELECT to_char(notkept.changetimestamp , 'dd Mon yyyy' ) as period, COUNT(*)
             FROM (
               SELECT DISTINCT ON (promisehash) *
               FROM not_kept_not_repaired
               WHERE  changetimestamp BETWEEN '$escapedFrom' AND '$escapedTo'
             ) notkept
             GROUP BY period"
        );

        $combinedResult = $this->combinePeriods($data["rows"]);
        return $this->decorateResponse($combinedResult);
    }

    /**
     * @param $periods
     *
     * @return array
     */
    private function decorateResponse($periods)
    {
        $data = [];
        foreach ($periods as $date => $count) {
            $data[] = ['date' => $date, 'count' => $count];
        }
        return $data;
    }

    /**
     * @param $periodWithData
     *
     * @return array
     */
    private function combinePeriods($periodWithData)
    {
        $defaultPeriods = $this->preparePeriod();
        foreach ($periodWithData as $value) {
            $defaultPeriods[$value[0]] = (int) $value[1];
        }
        return $defaultPeriods;
    }

    /**
     * @return array
     * @throws Exception
     */
    private function preparePeriod()
    {
        $period = new DatePeriod(
            new DateTime($this->from),
            new DateInterval('P1D'),
            new DateTime($this->to)
        );
        $periods = [];
        foreach ($period as $date) {
            $periods[$date->format('d M Y')] = 0;
        }
        return $periods;
    }
}
