<div class="settingsPage">
    <div class="left-column">
        <?php include('settingsSideBar.php'); ?>
    </div>
    <div class="right-column margin-bottom">
        <div class="pageTitle">
            <h1>
                <span>Mission Portal customization</span>
            </h1>
        </div>

        <div class="pullTop">
            <?php  if (!empty($this->session->flashdata('error'))) { ?>
                <div style="margin-top: 13px;">
                    <div class="alert alert-error">
                        <button class="close" data-dismiss="alert"><i class="bi bi-x"></i></button>
                        <?= $this->session->flashdata('error'); ?>
                    </div>
                </div>
            <?php } ?>
        </div>

        <form action="/customization/update" method="post" class="form-horizontal customization-form confirm-before-leave"
              enctype="multipart/form-data">
            <h3>Additional info</h3>
            <div class="control-group">
                <label for="password_confirm" class="control-label">Text on login page (html)</label>
                <div class="controls">
                    <textarea name="login_text" id="login_text" cols="50" rows="5"
                              style="width: 550px"><?= isset($login_text) ? htmlspecialchars($login_text) : '' ?></textarea>
                </div>
            </div>
            <hr/>
            <h3>Color scheme</h3>
            <h4 class="muted">Header</h4>
            <div class="control-group">
                <label for="header_color" class="control-label">Background color</label>
                <div class="controls">
                    <input name="header_color" style="background-color:#<?= isset($header_color) ? $header_color : '' ?>" id="header_color"
                           value="<?= isset($header_color) ? $header_color : '' ?>"/>
                </div>
            </div>
            <div class="control-group">
                <label for="header_text_color" class="control-label">Text color</label>
                <div class="controls">
                    <input name="header_text_color" style="background-color:#<?= isset($header_text_color) ? $header_text_color : '' ?>"
                           id="header_text_color" value="<?= isset($header_text_color) ? $header_text_color : '' ?>"/>
                </div>
            </div>
            <div class="control-group">
                <label for="header_links_color" class="control-label">Links color</label>
                <div class="controls">
                    <input name="header_links_color" style="background-color:#<?= isset($header_links_color) ? $header_links_color : '' ?>"
                           id="header_links_color" value="<?= isset($header_links_color) ? $header_links_color : '' ?>"/>
                </div>
            </div>
            <div class="control-group">
                <div class="controls">
                    <button class="btn btn-small btn-info reset-colors">Reset to default colors</button>
                </div>
            </div>
            <hr/>
            <h3>Company logo</h3>
            <div class="control-group">

                <div class="controls level-text">
                    <?php if ($company_logo) { ?>
                        <div style="margin-bottom:10px;">
                            <div>
                                <img src="<?= htmlspecialchars($company_logo) ?>?v=<?= mt_rand(0,99999)?>" style="max-height: 200px;"/>
                            </div>
                            <input type="checkbox" name="removeLogo" value="1"> Remove logo<br>

                        </div>
                    <?php } ?>
                    <input type="file" name="company_logo" size="20" title="Choose file"/>
                    <span class="help-block">Max size: 5MB , Max dimension: 1024x1024, Type: jpg/jpeg/png</span>

                </div>

                <label class="control-label" for="PDF_logo_file">Places to show logo</label>
                <div class="identifiers margin-bottom controls">
                    <p class="alert" style="display:none"></p>

                    <ul class="unstyled">
                        <li>
                            <label class="radio inline">
                                <input type="checkbox" name="logo_on_pdf"
                                       value="1" <?= isset($logo_on_pdf) && $logo_on_pdf == 1 ? 'checked' : '' ?> >
                                PDF report </label>
                        </li>
                        <li>
                            <label class="radio inline">
                                <input type="checkbox" name="logo_on_login"
                                       value="1" <?= isset($logo_on_login) && $logo_on_login == 1 ? 'checked' : '' ?>>
                                Login page </label>
                        </li>
                        <li>
                            <label class="radio inline">
                                <input type="checkbox" name="logo_on_header"
                                       value="1" <?= isset($logo_on_header) && $logo_on_header == 1 ? 'checked' : '' ?> >
                                On the header </label>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="buttons">
                <input type="submit" class="btn btn-primary btn-large pull-right">
            </div>
        </form>
    </div>
</div>