<?php
include_once __DIR__ . '/loader.php';

class Api_event_model extends Cf_Model
{
    public function process()
    {
        $apiEvents = $this->getEventsFromApi();

        if (is_array($apiEvents) && count($apiEvents) > 0) {
            $this->load->model('eventslog_model');
            $eventFactory = new EventsHandlerFactory();
            $ids = [];
            foreach ($apiEvents as $event) {
                $ids[] = $event['id'];
                $handler = $eventFactory->getHandler($event['event'], $event);
                $handler->setEventsLogModel($this->eventslog_model);
                $handler->handle($event);
            }
            $this->deleteEventsFromApi($ids);
        }
    }

    public function getEventsFromApi()
    {
        try{
            $jsonBody = $this->getRestClient()->get('/event');
            return json_decode($jsonBody, JSON_OBJECT_AS_ARRAY);
        }catch (Exception $e){
            log_message('debug', 'getEventsFromApi error:: ' . $e->getMessage());
        }

    }

    public function deleteEventsFromApi($ids)
    {
        try{
            if(is_array($ids) && count($ids) > 0){
                $jsonBody = $this->getRestClient()->delete('/event-batch', $ids);
                return json_decode($jsonBody, JSON_OBJECT_AS_ARRAY);
            }
        }catch (Exception $e){
            log_message('debug', 'deleteEventsFromApi error:: ' . $e->getMessage());
        }

    }

}