(function($) {
    $.widget('ui.hostsCompliance', {
        options: {
            baseUrl: '../',
            defaultbehaviour: true
        },

        header: null,
        colorEntryWrapper: $('<div class="colorEntryWrapper"></div>'),
        _create: function() {
            var $self = this;
            $self.element.append($self.header);
        },

        _init: function() {
            var $self = this;
            $self._active = true;
        },

        setContext: function(includes, excludes) {
            var $self = this;

            $self._context.includes = includes;
            $self._context.excludes = excludes;

            if ($self._active) $self.refresh();
        },

        setActive: function(state) {
            var $self = this;
            $self._active = state;
        },

        refresh: function() {
            var $self = this;
            common.globalSpinner.show();
            $self.element.html('');
            $.getJSON($self._requestUrls.hostCountAll($self, $self._context.includes), function(data) {
                $self.element.html('');
                var redPercent = 0;
                var greenPercent = 0;
                if (data.total) {
                    redPercent = parseInt(Math.round(data.red / data.total * 100), 10);
                    greenPercent = parseInt(Math.round(data.green / data.total * 100), 10);
                }

                var redData = {
                    'count': data.red,
                    'percent': redPercent
                };
                var greenData = {
                    'count': data.green,
                    'percent': greenPercent
                };

                $self._setHostCount('green', greenData, 'Hosts with 100% compliance.');
                $self._setHostCount('red', redData, 'Hosts with less than 100% compliance.');

            }).done(function(){
                common.globalSpinner.hide();
            }).fail(function(jqXHR, textStatus, errorThrown) {
                var opt = {
                    statusCode: jqXHR.status,
                    targetDiv: $self.colorEntryWrapper
                };
                common.showAjaxError(opt);
                common.globalSpinner.hide();
            });

        },

        _createColourEntry: function(colour, data, text) {
            var $self = this;
            var $entry = $('<div>');
            $entry.addClass('colourEntry stats span6');
            $entry.addClass(colour);

            var $h1 = $('<h1></h1>');
            $h1.html(data.count);

            var $h3 = $('<h3></h3>');
            var percent = data.percent || 0;
            $h3.html('(' + percent + '%' + ')');

            var $link = $('<a href="#">Show hosts</a >').click(function(e) {

                e.preventDefault();

                $self._trigger("colorentryclicked", e, {
                    'color': colour,
                    'includes': $self._context.includes,
                    'excludes': $self._context.excludes
                });


            });
            var $text = $('<p></p>').html(text);

            $h1.appendTo($entry);
            $h3.appendTo($entry);
            $text.appendTo($entry);
            if (data.count > 0) {
                $link.appendTo($entry);
            }
            return $entry;
        },

        _setHostCount: function(colour, data, text) {
            var self = this;
            var $colorDiv = self._createColourEntry(colour, data, text);
            self.element.append($colorDiv);
        },

        _context: {
            includes: [],
            excludes: []
        },

        _requestUrls: {

            hostCount: function(self, includes, colour) {

                return self.options.baseUrl + '/host/count?' +
                    'colour=' + colour + '&' +
                    'includes=' + encodeURIComponent(includes);
            },

            hostCountAll: function(self, includes) {
                return self.options.baseUrl + '/host/countCompliance?' + 'includes=' + encodeURIComponent(includes);
            }

        }
    });

    $.extend($.ui.hostsCompliance, {
        instances: []
    });

})(jQuery);