<div class="settingsPage">
    <div class="left-column">
            <?php include('settingsSideBar.php');?>
    </div>
    <div class="right-column">
        <div class="pageTitle">
            <h1>
                <span>Host identifier</span>
            </h1>
        </div>

        <div class="margin-bottom margin-top identifiers">
            <div class="identifiers margin-bottom controls" >
                <p class="alert" style="display:none"></p>

                <p class="description">The host identifier is the default attribute used everywhere in the Mission Portal, including reports and the APIs, to identify a given host.</p>

                <ul class="unstyled">
                    <?php
                    foreach ((array)$defaultList as $key=>$description)
                    {
                        $checked="";
                        if ($updated_host_identifier)
                        {
                            $checked = $updated_host_identifier == $key ? "checked":"";
                        }
                        $keyArray = explode('.', $key);
                        $scope = $keyArray[0];
                        $name= $keyArray[1];
                        $eg  = !empty($exampleValue[$key]) ? trim($exampleValue[$key]) : null ;

                    ?>
                        <li>
                            <label class='radio inline'>
                            <input class='scope' data-scope="<?= htmlspecialchars($scope) ?>" data-name="<?= htmlspecialchars($name) ?>" type='radio' name='hosts' value='' <?= htmlspecialchars($checked) ?>>
                                <?= htmlspecialchars($description) ?><?php if (!empty($eg)) { ?><span class='help-block'>e.g. <?= htmlspecialchars($eg) ?></span><?php } ?>
                            </label>
                        </li>
                    <?php } ?>
                </ul>
            </div>

                <div class="buttons">
                    <div class="pull-right">
                        <button id="apply-identifier" class="btn btn-large btn-primary">Apply</button>
                    </div>
                </div>
        </div>
    </div>
 </div>

<script type="text/javascript">
    $(document).ready(function(){
        $(this).scrollTop(0);

        function  updateIdentifier(parameters) {
            $.ajax({
                type: "POST",
                url: "<?php echo site_url(); ?>/settings/updateSystemIdentifierSetting",
                data: parameters,
                async: false,
                dataType:'json',
                success: function(data) {
                    $('p.alert').show();
                    $('p.alert').html(data.message).addClass('alert-success');
                },
                error:function(xhr, status, error) {
                    var response = $.parseJSON(xhr.responseText);
                    $('p.alert').show();
                    $('p.alert').html(response.message).addClass('alert-error');;
                }
            });
        }

        // row selection
        $('#apply-identifier').click(function() {

            var target = $(".scope:checked");
            var scope = target.attr('data-scope');
            var name = target.attr('data-name');
            var parameters = {'scope':scope,'name':name,'update':true};

            $('p.alert').hide();
            setTimeout(
                function() {
                    updateIdentifier(parameters)
                },
            200);
        });

    });
</script>