<?php
function handleWarning($errno, $errstr, $errfile, $errline) {
    // error was suppressed with the @-operator
    if (0 === error_reporting()) {
        return false;
    }

    throw new ErrorException($errstr, 0, $errno, $errfile, $errline);
}

function deleteAll($directory, $empty = false)
{
    if(substr($directory,-1) == "/") {
        $directory = substr($directory,0,-1);
    }

    if(!file_exists($directory) || !is_dir($directory)) {
        return false;
    } elseif(!is_readable($directory)) {
        return false;
    } else {
        $directoryHandle = opendir($directory);

        while ($contents = readdir($directoryHandle)) {
            if($contents != '.' && $contents != '..') {
                $path = $directory . "/" . $contents;

                if(is_dir($path)) {
                    deleteAll($path);
                } else {
                    unlink($path);
                }
            }
        }

        closedir($directoryHandle);

        if($empty == false) {
            if(!rmdir($directory)) {
                return false;
            }
        }

        return true;
    }
}

function is_dir_empty($dir)
{
  if (!is_readable($dir)) return NULL;
  $handle = opendir($dir);
  while (false !== ($entry = readdir($handle)))
  {
    if ($entry != "." && $entry != "..")
    {
      return FALSE;
    }
  }
  return TRUE;
}

/**
 * Copy a file, or recursively copy a folder and its contents
 */
function copyr($source, $dest, $ignoreHidden = true)
{
    // Check for symlinks
    if (is_link($source))
    {
        return symlink(readlink($source), $dest);
    }

    // Simple copy for a file
    if (is_file($source))
    {
        return copy($source, $dest);
    }

    // Make destination directory
    if (!is_dir($dest))
    {
        mkdir($dest);
    }

    // Loop through the folder
    $dir = dir($source);
    while (false !== $entry = $dir->read())
    {
        // Skip pointers
        if ($entry == '.' || $entry == '..') {
            continue;
        }

        if ($ignoreHidden && (substr($entry, 0, 1) == '.')) {
            continue;
        }

        // Deep copy directories
        copyr("$source/$entry", "$dest/$entry");
    }

    // Clean up
    $dir->close();
    return true;
}
?>