<div class="contentWrapper">
    <div class="pageTitle overflow">
        <h1>
            <span ng-show="widgetData.name">Alerts in '{{widgetData.name}}'</span>
            <span ng-hide="widgetData.name">Alerts in widget</span>
        </h1>
    </div>

    <div>
        <label class="checkbox margin-right inline">
            <input type="checkbox" ng-init="alertFilters.triggered=true" ng-model="alertFilters.triggered">
            Triggered
        </label>
        <label class="checkbox margin-right inline">
            <input type="checkbox" ng-init="alertFilters.ok=true" ng-model="alertFilters.ok">
            Ok
        </label>
        <label class="checkbox margin-right inline">
            <input type="checkbox" ng-init="alertFilters.paused=true" ng-model="alertFilters.paused">
            Paused
        </label>

        <input type="text" placeholder="Search alert or condition name" ng-model="searchAlerts" style="vertical-align:top">
    </div>

    <div><?php $this->load->view('/partials/_notification'); ?></div>
    <div ng-show="filteredAlerts&&!filteredAlerts.length">
        <div class="alert alert-warning">There are no alerts in this widget</div>
    </div>

    <div ng-show="filteredAlerts.length" class="row-fluid float-left">

        <div class="row-fluid float-left">
            <div class="span4 pagination">
                <p>Showing {{Math.min(filteredAlerts.length, pageSize)}} of {{filteredAlerts.length}} results on {{numberOfAlertPages(filteredAlerts.length).length}} page<span ng-hide="numberOfAlertPages(filteredAlerts.length).length===1">s</span></p>
            </div>


            <div class="span8">
                <div class="btn-group pull-right">
                    <a data-toggle="dropdown" class="btn dropdown-toggle">
                        <span>{{pageSize}}</span>
                        <span class="caret"></span>
                    </a>
                    <ul class="dropdown-menu dropup">
                        <li ng-repeat="size in DCA.Page_size">
                            <a ng-click="setPageSize(size)" href="javascript:void(0)">{{size}}</a>
                        </li>
                    </ul>
                </div>

                <div class="inline pagination pull-right" style="margin:0">
                    <ul>
                        <li ng-if="currentPage>2">
                            <a title="Go to First Page" ng-click="setCurrentPage(0)" href="javascript:void(0)">First</a>
                        </li>
                        <li ng-repeat="page in numberOfAlertPages(filteredAlerts.length) track by $index"
                            ng-show="$index>currentPage-3 && $index<currentPage+3"
                            ng-class="{active:$index===currentPage}">
                            <a ng-click="setCurrentPage($index)" href="javascript:void(0)">{{$index+1}}</a>
                        </li>
                        <li ng-if="currentPage+3<numberOfAlertPages(filteredAlerts.length).length">
                            <a title="Go to Last Page" ng-click="setCurrentPage((numberOfAlertPages(filteredAlerts.length).length)-1)" href="javascript:void(0)">Last</a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <table class="table float-left margin-top table-horizontal">
            <thead>
            <th class="sort-head">
                <a ng-click="orderByField='name'; reverseSort = !reverseSort" href="javascript:void(0)">
                    Alert name
                    <span ng-show="orderByField=='name'">
                        <i ng-show="!reverseSort" class="icon-chevron-down"></i>
                        <i ng-show="reverseSort" class="icon-chevron-up"></i>
                    </span>
                </a>
            </th>

            <th class="sort-head">
                <a ng-click="orderByField='sev'; reverseSort = !reverseSort" href="javascript:void(0)">
                   Severity
                    <span ng-show="orderByField=='sev'">
                        <i ng-show="reverseSort" class="icon-chevron-down"></i>
                        <i ng-show="!reverseSort" class="icon-chevron-up"></i>
                    </span>
                </a>
            </th>
            <th class="sort-head">
                 <a ng-click="orderByField='rule.name'; reverseSort = !reverseSort" href="javascript:void(0)">
                    Condition
                    <span ng-show="orderByField=='rule.name'">
                        <i ng-show="!reverseSort" class="icon-chevron-down"></i>
                        <i ng-show="reverseSort" class="icon-chevron-up"></i>
                    </span>
                </a>
            </th>
            <th class="right sort-head">
                <a ng-click="orderByField='failHosts'; reverseSort = !reverseSort" href="javascript:void(0)">
                    <span>Triggered on</span>
                    <span ng-show="orderByField=='failHosts'">
                        <i ng-show="!reverseSort" class="icon-chevron-down"></i>
                        <i ng-show="reverseSort" class="icon-chevron-up"></i>
                    </span>
                </a>
            </th>

            <th class="right sort-head">
                 <a ng-click="orderByField='lastStatusChange'; reverseSort = !reverseSort" href="javascript:void(0)">
                    Triggered at
                    <span ng-show="orderByField=='lastStatusChange'">
                        <i ng-show="!reverseSort" class="icon-chevron-down"></i>
                        <i ng-show="reverseSort" class="icon-chevron-up"></i>
                    </span>
                </a>
            </th>
            <th class="right sort-head">
                <a ng-click="orderByField='lastCheck'; reverseSort = !reverseSort" href="javascript:void(0)">
                    Last run
                    <span ng-show="orderByField=='lastCheck'">
                        <i ng-show="!reverseSort" class="icon-chevron-down"></i>
                        <i ng-show="reverseSort" class="icon-chevron-up"></i>
                    </span>
                </a>
            </th>
            <th colspan="3">Actions</th>
            </thead>
            <tbody>
                <tr ng-repeat="alert in filteredAlerts = (widgetAlerts | alertSearchFilter:searchAlerts | alertsFilter:alertFilters) | orderBy:-failHosts | orderBy:severitySortFunction:reverseSort | startFrom:currentPage*pageSize | limitTo:pageSize | orderBy:orderByField:reverseSort track by $index" >
                    <td style="white-space:nowrap">
                        <a class="check-link" ng-href="/dashboard/alerts/result/{{alert.id}}" onclick="event.stopPropagation();">{{alert.name}}</a>
                    </td>

                    <td>
                        <span class="upper-first">{{alert.severity}}</span>
                    </td>

                    <td>

                        <span>{{alert.rule.name}}</span>

                        <div class="muted" ng-switch on="alert.rule.type">
                            <div ng-switch-when="policy">
                                <ul class="unstyled break-all">
                                    <li ng-show="alert.rule.policyConditions.filterBy && alert.rule.policyConditions.filterItemName">
                                        <span class="upper-first"><h5 class="inline">{{alert.rule.policyConditions.filterBy}}:</h5></span> {{alert.rule.policyConditions.filterItemName}}
                                    </li>
                                    <li ng-show="alert.rule.policyConditions.promisehandle">
                                        <h5 class="inline">Promise handle:</h5> {{alert.rule.policyConditions.promisehandle}}
                                    </li>
                                    <li>
                                        <h5 class="inline">Status:</h5> <span class="upper-first">{{convertStatus(alert.rule.policyConditions.promiseoutcome)}}</span>
                                    </li>
                                </ul>
                            </div>

                            <div ng-switch-when="inventory">
                                 <ul class="unstyled break-all">
                                    <li ng-repeat="filter in alert.rule.inventoryConditions.filters">
                                        <h5 class="inline">{{filter.label}}:</h5> {{filter.condition | FilterConditionLabel:filter}} <span ng-show="filter.type==='string'">'{{filter.value}}'</span><span ng-show="filter.type!=='string'">{{filter.value}}
                                    </li>
                                </ul>
                            </div>

                           <div ng-switch-when="softwareupdate">
                               <ul class="unstyled break-all">
                                   <li>
                                       <b>Package name:</b> <span ng-if="alert.rule.softwareUpdateConditions.patchname!=''">{{alert.rule.softwareUpdateConditions.patchname}}</span><span ng-if="!alert.rule.softwareUpdateConditions.patchname">All</span>
                                   </li>
                                   <li>
                                       <b>Architecture:</b> <span ng-if="alert.rule.softwareUpdateConditions.patcharchitecture!=''">{{alert.rule.softwareUpdateConditions.patcharchitecture}}</span><span ng-if="!alert.rule.softwareUpdateConditions.patcharchitecture">All</span>
                                   </li>
                               </ul>
                            </div>
                        </div>

                    </td>

                    <td class="right">

                        <span ng-class="{'red':alert.failHosts>0}" ng-show="alert.totalHosts && !alert.paused">
                            {{alert.failHosts}}/{{alert.totalHosts}}
                        </span>
                        <span ng-show="alert.paused">
                            - / -
                        </span>
                         <span ng-show="alert.status=='internal_error'">
                            internal error
                        </span>
                    </td>
                    <td class="right">
                        <span ng-show="alert.lastStatusChange&&alert.failHosts>0">{{alert.lastStatusChange | convertTime}}</span>
                        <span ng-show="alert.failHosts<1||!alert.lastStatusChange">&mdash;</span>
                    </td>
                    <td class="right">
                        <span ng-show="alert.lastCheck">{{alert.lastCheck | convertTime}}</span>
                        <span ng-show="!alert.lastCheck">&mdash;</span>
                    </td>
                    <td>
                        <div ng-show="!alert.paused">
                            <div class="btn-group">
                                 <a data-toggle="dropdown" class="btn no-btn dropdown-toggle">
                                     <span ng-hide="">pause</span>
                                     <i class="icon-caret-down"></i>
                                 </a>
                                 <ul class="dropdown-menu">
                                     <li ng-repeat="(itemId, item) in DCA.Pause_dropDown">
                                         <a ng-click="pauseAlert(alert,item.value)">{{item.label}}</a>
                                     </li>
                                 </ul>
                             </div>
                        </div>
                        <div ng-show="alert.paused">
                            <div class="btn-group no-btn">
                                 <a data-toggle="dropdown" class="btn  no-btn dropdown-toggle">
                                      <span ng-show="isAlertAlive(alert.pause)"><i class="icon-pause"></i>{{alert.pause | convertTime}}</span>
                                      <span ng-show="!isAlertAlive(alert.pause)"><i class="icon-pause"></i>Paused</span>
                                     <i class="icon-caret-down"></i>
                                 </a>
                                 <ul class="dropdown-menu">
                                     <li>
                                         <a ng-click="resumeAlert(alert)" href="javascript:void(0)">Resume</a>
                                     </li>
                                 </ul>
                             </div>
                        </div>
                    </td>
                    <td>
                        <a ng-href="/dashboard/alerts/edit/{{alert.id}}">edit</a>
                    </td>
                    <td>
                        <a ng-click="removeAlertFromWidget(widgetData.id, alert.id, alert.name); $event.stopPropagation();" href="javascript:void(0)">remove</a>
                    </td>
                </tr>
            </tbody>
        </table>

        <div class="btn-group pull-right">
            <a data-toggle="dropdown" class="btn dropdown-toggle">
                <span>{{pageSize}}</span>
                <span class="caret"></span>
            </a>
            <ul class="dropdown-menu dropup">
                <li ng-repeat="size in DCA.Page_size">
                    <a ng-click="setPageSize(size)" href="javascript:void(0)">{{size}}</a>
                </li>
            </ul>
        </div>

        <div class="inline pagination pull-right" style="margin:0">
            <ul>
                <li ng-if="currentPage>2">
                    <a title="Go to First Page" ng-click="setCurrentPage(0)" href="javascript:void(0)">First</a>
                </li>
                <li ng-repeat="page in numberOfAlertPages(filteredAlerts.length) track by $index"
                    ng-show="$index>currentPage-3 && $index<currentPage+3"
                    ng-class="{active:$index===currentPage}">
                    <a ng-click="setCurrentPage($index)" href="javascript:void(0)">{{$index+1}}</a>
                </li>
                <li ng-if="currentPage+3<numberOfAlertPages(filteredAlerts.length).length">
                    <a title="Go to Last Page" ng-click="setCurrentPage((numberOfAlertPages(filteredAlerts.length).length)-1)" href="javascript:void(0)">Last</a>
                </li>
            </ul>
        </div>

    </div>

    <div class="margin-bottom overflow-hidden float-left">
        <ul class="nav pills token token-cyan">
            <li>
                <a ng-href="/dashboard/alerts/add?widgetId={{widgetData.id}}" >
                    <span><i class="icon-plus"></i></span><span>Add new alert</span>
                </a>
            </li>
        </ul>
    </div>

    <div class="buttons" style="clear:both">
        <button ng-disabled="!widgetData.id" class="btn btn-large" ng-click="deleteWidget(widgetData.id)">Remove widget</button>
    </div>
</div>

<script type="text/javascript">
    $(function () {
        $("[rel='tooltip']").tooltip();
    });
</script>