<?php

/**
 * @rbacName Modify all users' reports
 * @rbacDescription View, Update, Delete
 * @rbacGroup Reports
 * @rbacAlias reports.admin
 */

class Advancedreports extends Cf_Controller
{
    private $defaultFilter = array();

    function __construct()
    {
        parent::__construct();
        $this->load->model('search_save_model');
        $this->load->helper('string');
        $this->load->database();



        if(CLI === false)
        {
            $this->username = $this->session->userdata('username');

            $this->load->model('advancedreports_model');
            $this->advancedreports_model->setRestClient($this->getRestClient());

            setCurrentApplication('advancedreports');


            // set username and filter context to the search_save_model,
            $this->search_save_model->setCurrentUserName($this->username);

            $roles = $this->getUserRoles($this->username);
            $this->userBasedFilter = $this->search_save_model->_getUserbasedFilter(isActionAllowed('reports.admin'), $roles);

            $this->search_save_model->setDefaultFilter($this->userBasedFilter);

        }
    }

    function index($id = NULL)
    {
        $requiredcss = array(
            array('angularjs-ui/angular-ui.min.css'),
            array('../../../scripts/node_modules/bootstrap-multiselect/dist/css/bootstrap-multiselect.css'),
            array('../../../scripts/node_modules/daterangepicker/daterangepicker.css')
        );

        $this->carabiner->css($requiredcss);

        $requiredjs = array(
            array('advancedreports/libs/jquery.ba-throttle-debounce.min.js'),
            array('node_modules/underscore/underscore-min.js'),

            array('node_modules/angular/angular.min.js'),
            array('node_modules/angular-cookies/angular-cookies.min.js'),
            array('node_modules/angular-route/angular-route.min.js'),
            array('node_modules/angular-sanitize/angular-sanitize.min.js'),

            // ui
            array('libs/angularjs-ui/ui-bootstrap-tpls-0.9.0.min.js'),
            array('node_modules/angular-ui-sortable/dist/sortable.min.js'),
            array('node_modules/bootstrap-multiselect/dist/js/bootstrap-multiselect.min.js'),

            array('node_modules/angular-chosen-localytics/dist/angular-chosen.min.js'),

            //Class extend
            array('libs/class.js'),
            array('libs/baseclasses/BaseController.js'),

            // project
            array('advancedreports/dca.js'),
            array('dashboard/dca.js'),
            array('advancedreports/app.js'),

            array('advancedreports/controllers/indexController.js'),
            array('advancedreports/controllers/allreportsController.js'),
            array('advancedreports/controllers/resultController.js'),
            array('advancedreports/controllers/editController.js'),
            array('advancedreports/controllers/scheduleController.js'),

            array('advancedreports/controllers/inventoryController.js'),
            array('advancedreports/controllers/changesController.js'),
            array('advancedreports/controllers/fimController.js'),
            array('advancedreports/controllers/healthDiagnosticController.js'),
            array('advancedreports/controllers/complianceController.js'),


            array('advancedreports/services/reportService.js'),

            array('advancedreports/services/wizardSharedService.js'),
            array('advancedreports/services/notificationService.js'),
            array('advancedreports/services/paginationService.js'),
            array('advancedreports/services/modalWindowService.js'),
            array('advancedreports/services/healthDiagnosticsService.js'),
            array('advancedreports/services/fileChangesSqlService.js'),
            array('advancedreports/services/FimService.js'),
            array('dashboard/services/autocompleteService.js'),
            array('dashboard/services/rulesService.js'),

            array('advancedreports/directives/directives.js'),
            array('common_directives/high-chart.js'),
            array('common_directives/select-file.js'),
            array('common_directives/autocompleteInput.js'),
            array('common_directives/health-issue.js'),
            array('common_directives/breadcrumbs.js'),
            array('common_directives/objectsFilter.js'),
            array('common_directives/tableDirective.js'),
            array('common_directives/groups/selectGroup_directive.js'),
            array('common_directives/groups/saveFilterAsGroup_directive.js'),
            array('common/helper.js'),
            array('common/filters.js'),

            array('advancedreports/filters.js'),

            array('advancedreports/helpers/sqlHelper.js'),
            array('advancedreports/helpers/commonHelper.js'),
            array('advancedreports/helpers/complianceHelpers.js'),
            array('common_directives/inventory/services/inventoryDataService.js'),
            array('common_directives/inventory/services/inventoryFilterService.js'),
            array('hubManagement/services/hubManagementService.js'),

            array('dashboard/filters/dashFilters.js'),

            //addons for custom field form
            array('node_modules/jquery-ui-timepicker-addon/dist/jquery-ui-timepicker-addon.min.js'),
            // used in download form ?
            array('node_modules/jquery-form/dist/jquery.form.min.js'),
            array('node_modules/jquery-validation/dist/jquery.validate.min.js'),

            // additional fields for inventory. Application specific!
            array('advancedreports/invenory_data_addons.js'),

            // additional fields for inventory. Application specific!
            array('advancedreports/changes_data_addons.js'),

            //inventory directive (for filter)
            array('common_directives/inventory/inventory_dca.js'),
            array('common_directives/inventory/services/inventoryService.js'),
            array('common_directives/inventory/helpers/inventoryHelper.js'),
            array('common_directives/inventory/directives/inventoryFilterDirectiveCtrl.js'),
            array('common_directives/inventory/directives/inventoryFilter_directive.js'),
            array('common_directives/condition/addConditionDirective.js'),
            array('common_directives/editableField.js'),

            // environment selector
            array('common_directives/environment/services/environmentService.js'),
            array('common_directives/environment/services/naviTreeService.js'),
            array('common_directives/environment/directives/environment_directive.js'),
            array('common_directives/environment/directives/environmentSelectionDirective.js'),

            array('node_modules/moment/min/moment.min.js'),
            array('node_modules/daterangepicker/daterangepicker.js'),
            array('node_modules/angular-daterangepicker/js/angular-daterangepicker.min.js'),

            // change reporting
            array('common_directives/changes/changes_dca.js'),
            array('common_directives/changes/directives/changesFilterDirectiveCtrl.js'),
            array('common_directives/changes/directives/changesFilter_directive.js'),

            // hosts include exclude selector
            array('common_directives/hostsInclude/services/paginationService.js'),
            array('common_directives/hostsInclude/services/includeExcludeService.js'),
            array('common_directives/hostsInclude/services/autocompleteService.js'),
            array('common_directives/hostsInclude/services/naviTreeService.js'),
            array('common_directives/hostsInclude/directives/include_exclude_directive.js'),
            array('common_directives/hostsInclude/directives/includeExcludeSelectionDirective.js'),
            array('common_directives/hostsInclude/directives/includeExcludeByHostkeyDirective.js'),

            ['groups/services/personalGroupsService.js'],
            ['groups/services/sharedGroupsService.js'],

            array('dashboard/helpers/complianceWidgetHelper.js')
        );

        $highchartsjs = array(
            array('node_modules/highcharts/highcharts.js'),
            array('node_modules/highcharts/highcharts-more.js'),
            array('node_modules/highcharts/modules/no-data-to-display.js'), //module for android support
            array('node_modules/highcharts/modules/exporting.js'),
            array('node_modules/highcharts/modules/solid-gauge.js'),
            array('node_modules/highcharts/modules/exporting.js'),
            array('node_modules/highcharts/modules/offline-exporting.js'),
            array('node_modules/highcharts/modules/accessibility.js')
        );

        if (isDarkMode()) {
            $highchartsjs = array_merge($highchartsjs, [['node_modules/highcharts/themes/dark-unica.js']]);
        }

        $this->carabiner->js($requiredjs, $requiredjs, TRUE, FALSE, 'footer');
        $this->carabiner->js($highchartsjs, $highchartsjs, TRUE, FALSE, 'footer');


        $this->load->model('MailSettingsModel');
        $defaultFromEmail = $this->MailSettingsModel->getSetting('default_from_email');
        $emailFrom = $defaultFromEmail ? $defaultFromEmail : trim($this->settings_model->app_settings_get_item('appemail'));
        $emailFrom = ($emailFrom) ? $emailFrom : '';


        $report_title = trim($this->input->post('report_title'));
        if(empty($report_title)) {
            $report_title = $this->settings_model->app_settings_get_item('advanced_report_title');
        }

        $report_description = $this->input->post('report_description');
        if (empty($report_description))
        {
            $default_descr = $this->settings_model->app_settings_get_item('advanced_report_description_type');

            if($default_descr === 'CURRENT_DATETIME') {
                $report_description = 'Generated: '. getDateStatus(time(), true, true);
            }
        }


        $emailSubject = $this->input->post('subjectEmail');
        if (empty($emailSubject)) {
            $emailSubject = $report_title;
        }

        $emailBody = $this->input->post('emailBody');
        if(empty($emailBody)) {
            $emailBody = $report_description;
        }


        // all roles needed to provide the ability to share a report to them
        $roles = $this->getAllAvailableUserRoles();

        $data = array(
            'title'         => $this->lang->line('mission_portal_title') . " - " . 'Reports',


            'savedItemId'   => $id,
            'emailFrom'     => $emailFrom,
            'emailSubject'  => $emailSubject,
            'emailBody'     => $emailBody,
            'report_link'   => site_url('/pdfreports/index').'/type/advancedreports',

            'custom_title_descr' => true,
            'report_title'       => $report_title,
            'report_description' => $report_description,

            'roles'         => $roles,
            'username' => $this->username
            );

        $this->template->load('template', 'advancedreports/index', $data);
    }


    function results() {
        $SQLString      = $this->input->post('SQLString', false);

        $SQLString = urldecode($SQLString);

        $sortColumn     = (string) $this->input->post('sortColumn', true);
        $sortDescending = (bool)$this->input->post('sortDescending');
        $skip           = (int)$this->input->post('skip', true);
        $limit          = (int)$this->input->post('limit', true);

        $includes       = (array) $this->input->post('includes', true);
        $excludes       = (array) $this->input->post('excludes', true);
        $inventoryFilter = isset($_REQUEST['inventoryFilter']) ? $_REQUEST['inventoryFilter'] : [];
        $apiUrl = $this->input->post('apiUrl') ? $this->input->post('apiUrl') : '/query';

        if ($SQLString === false && trim($SQLString) == ''  ) {
            $this->search_save_model->setError($this->lang->line('advancedreports_SQL_string_is_empty'), 500);
            $errors = $this->search_save_model->getErrors();

            $data = json_encode($errors);
            respond_internal_error($data);

            return;
        }
        try
        {
            $data = $this->advancedreports_model->runQuery(
                $this->username,
                $SQLString,
                $sortColumn,
                $sortDescending,
                $skip,
                $limit,
                $includes,
                $excludes,
                $inventoryFilter,
                $apiUrl
            );
            if(isset($GLOBALS['CF_HOOKS']['beforeSQLOutput']) && is_array($GLOBALS['CF_HOOKS']['beforeSQLOutput']) && count($GLOBALS['CF_HOOKS']['beforeSQLOutput']))
            {
                    foreach($GLOBALS['CF_HOOKS']['beforeSQLOutput'] as $callback)
                    {
                            $this->load->hookload($this, $callback[0]);
                            $data = $this->{$callback[0]}->{$callback[1]}($this, $data);
                    }
            }
            respond_ok(json_encode($data));
        }
        catch (Exception $e)
        {
            $this->search_save_model->setError($e->getMessage(), 500);
            $errors = $this->search_save_model->getErrors();
            $data = json_encode($errors);
            respond_internal_error($data);
        }
    }

    public function load($id)
    {
        if (empty($id)) {
            $this->search_save_model->setError($this->lang->line('advancedreports_empty_report_name'), 406);
            $errors = $this->search_save_model->getErrors();

            $data = json_encode($errors);
            respond_internal_error($data);

            return;
        }

        $id = (int)html_entity_decode(rawurldecode($id));
        $is_admin = isActionAllowed('reports.admin');
        $roles = $this->getUserRoles($this->username);

        $filter = $this->search_save_model->_getAllAvailableReportsFilter($is_admin, $roles);

        if ($filter === FALSE) {
            $this->search_save_model->setError($this->lang->line('advancedreports_empty_lits'), 404);
            $errors = $this->search_save_model->getErrors();

            $data = json_encode($errors);
            respond_internal_error($data);
            return;
        }

        $filter .= !empty($filter) ? " AND id=$id " : "id=$id";

        $offset = '';
        $limit = '';
        $order = array();
        $showSchedules = 'user';


        $itemLoaded = $this->search_save_model->get_all_search($filter, $offset, $limit, $order, $showSchedules, $is_admin);

        if (empty($itemLoaded)) {
            $this->search_save_model->setError($this->lang->line('advancedreports_not_found'), 404);
            $errors = $this->search_save_model->getErrors();

            $data = json_encode($errors);
            respond_internal_error($data);

            return;
        }
        respond_ok(json_encode($itemLoaded[0]));

    }


    function loadalert($id)
    {
        $this->load->model(array('dashboard/alerts_model', 'dashboard/rules_model'));

        if (empty($id))
        {
            $this->search_save_model->setError($this->lang->line('advancedreports_alert_id_empty'), 406);
            $errors = $this->search_save_model->getErrors();
            $data = json_encode($errors);
            respond_internal_error($data);
            return;
        }

        $filter = array();
        $filter['id'] =  intval($id);


        $alerttmp = $this->alerts_model->get_only_alerts($filter);
        $alertObj = $alerttmp[0];

        if (empty($alertObj)) {
            $this->search_save_model->setError($this->lang->line('advancedreports_unable_to_load_alert'), 406);
            $errors = $this->search_save_model->getErrors();
            $data = json_encode($errors);
            respond_internal_error($data);
            return;
        }


        if (empty($alertObj->ruleid)) {
            $this->search_save_model->setError($this->lang->line('advancedreports_rule_id_empty'), 406);
            $errors = $this->search_save_model->getErrors();
            $data = json_encode($errors);
            respond_internal_error($data);
            return;
        }

        $ruleFilter = array();
        $ruleFilter['id'] = intval($alertObj->ruleid);


        $ruleTmp = $this->rules_model->get_all_rules($ruleFilter);

        $ruleObj = $ruleTmp[0];


        if (empty($ruleObj)) {
            $this->search_save_model->setError($this->lang->line('advancedreports_unable_to_load_rule'), 406);
            $errors = $this->search_save_model->getErrors();
            $data = json_encode($errors);
            respond_internal_error($data);
            return;
        }

        $result['alert'] = $alertObj;
        $result['rule']  = $ruleObj;

        respond_ok(json_encode($result));
    }

    public function listsearches()
    {
        $this->load->model('favourite_reports_model');
        $is_admin = isActionAllowed('reports.admin');

        $reportCriteria = (new ReportCriteria())
            ->setUsername($this->username)
            ->setRoles($this->getUserRoles($this->username))
            ->setTab($this->input->post('tab'))
            ->setIsReportsAdmin($is_admin)
            ->setReportCategory($this->input->post('reportCategory', true) ?? [])
            ->setType($this->input->post('type', true))
            ->setOwnReports(!empty($this->input->post('ownReports')) && $this->input->post('ownReports') === 'true');

        $limit = $this->input->post('limit', true);
        $page = $this->input->post('page', true);
        $sortColumn = $this->input->post('sortColumn', true);
        $sortDescending = $this->input->post('sortDescending', true);
        if ($sortDescending == 0) {
            $sortDirection = 'ASC';
        } else {
            $sortDirection = 'DESC';
        }

        $offset = ($page - 1) * $limit;


        $filter = $this->search_save_model->reportsListFilter($reportCriteria);

        //get total reports
        $total = $this->search_save_model->get_count_search($filter);

        $items = $this->search_save_model->get_all_search($filter, $offset, $limit, array($sortColumn, $sortDirection), 'check_only', $is_admin);

        $result['total'] = $total;
        $result['items'] = $this->_removeLegacyDataFromReportList($items);


        if (!empty($result)) {
            respond_ok(json_encode($result));
        } elseif (empty($result)) {
            $this->search_save_model->setError($this->lang->line('advancedreports_empty_lits'), 404);
            $errors = $this->search_save_model->getErrors();
            $data = json_encode($errors);
            respond_internal_error($data);
        }
    }

    function listallsearches()
    {
        $is_admin = isActionAllowed('reports.admin');
        $roles    = $this->getUserRoles($this->username);

        $filter = $this->search_save_model->_getExcludeOwnFilter($is_admin, $roles);


        if (empty($filter))
        {
            $this->search_save_model->setError($this->lang->line('advancedreports_empty_lits'), 404);
            $errors = $this->search_save_model->getErrors();

            $data = json_encode($errors);
            respond_internal_error($data);

            return;
        }


        $reportCategory  = $this->input->post('reportCategory', true);
        if (!empty($reportCategory))
        {
            if (!empty($filter))
            {
                $filter .= ' AND ';
            }
            $filter .= " reportCategory IN ('". implode("','", escapeArrayValues($reportCategory))."')";
        }


        $limit = $this->input->post('limit', true);

        $page  = $this->input->post('page', true);

        $offset = ($page-1) * $limit;

        $sortColumn      = $this->input->post('sortColumn',     true);
        $sortDescending  = $this->input->post('sortDescending', true);

        if ($sortDescending == 0)
        {
            $sortDirection = 'ASC';
        }
        else
        {
            $sortDirection = 'DESC';
        }


        //get total reports
        $total = $this->search_save_model->get_count_search($filter);

        $items = $this->search_save_model->get_all_search($filter, $offset, $limit, array($sortColumn, $sortDirection), 'check_only', $is_admin);

        $result['total'] = $total;
        $result['items'] = $this->_removeLegacyDataFromReportList($items);

        if (!empty($result))
        {
            respond_ok(json_encode($result));
        }
        elseif (empty($result))
        {
            $this->search_save_model->setError($this->lang->line('advancedreports_empty_lits'), 404);
            $errors = $this->search_save_model->getErrors();

            $data = json_encode($errors);
            respond_internal_error($data);

            return;
        }
    }


    function save()
    {
        // we will use username for RBAC
        $username = $this->session->userdata('username');

        $report_title = $this->input->post('report_title', true);
        $type         = $this->input->post('type'); // default - for predefined reports, advanced - for advanced reports
        $label        = $this->input->post('search_name', true);
        $id           = $this->input->post('id', true);
        $category     = $this->input->post('reportCategory', true);
        $searchUrl    = $this->input->post('search_url', false);
        $searchParams = $this->input->post('search_params', false);
        $searchParams = urldecode($searchParams);

        $sharedPermissionTmp = $this->input->post('sharedPermission', false);
        $sharedPermission = $this->_formatSharedPermission(json_decode($sharedPermissionTmp));

        $is_public = $this->input->post('is_public', true);
        $is_public = (strtolower($is_public) === 'true' ? 1 : 0);

        $overwrite = $this->input->post('overwrite', true);

        //cast
        $overwrite = ($overwrite == 'true' ? true: false);

        $AdvancedReportsData = $this->input->post('AdvancedReportsData', false);

        if ($category!= 'compliance_report' && empty($searchParams))
        {
            $this->search_save_model->setError($this->lang->line('advancedreports_empty_report'), '500');
            $errors = $this->search_save_model->getErrors();
            $data = json_encode($errors);
            respond_internal_error($data);
            return;
        }

        $advancedData = json_decode($AdvancedReportsData['SQL'], associative: true);
        $isReportBasedOnPersonalGroup = isset($advancedData['selectedGroup']) && $advancedData['selectedGroup']['type'] === 'personal';
        if ($isReportBasedOnPersonalGroup && $is_public === 1) {
            respond_internal_error($this->lang->line('advancedreports_share_personal_group'));
            return;
        }


        // check if report already exist, before inserting new
        $filter = $this->userBasedFilter;
        $filter = $filter. sprintf(" AND label = '%s'", $this->db->escape_str($label));

        $offset = '';
        $limit = '';
        $order = array();
        $showSchedules = 'all';
        $is_admin = isActionAllowed('reports.admin');

        $oldR = $this->search_save_model->get_all_search($filter, $offset, $limit, $order, $showSchedules, $is_admin);

        $oldReport = array();

        if (!empty($oldR))
        {
            $oldReport = $oldR[0];
        }

        $data = array(
            'username'   => $username,
            'id'         => $id,
            'url'        => $searchUrl,
            'reportType' => $report_title,
            'type'       => $type,
            'label'      => $label,
            'reportCategory' => $category,
            'date'       => time(),
            'params'     => $searchParams,
            'sharedPermission'    => $sharedPermission,
            'AdvancedReportsData' => $AdvancedReportsData,
            'is_public'     => $is_public
        );



        $obj = $this->search_save_model->insert($data, $overwrite, isActionAllowed('reports.admin'));

        if (!$obj) //not able to insert
        {
            $errors = $this->search_save_model->getErrors();
            $data = json_encode($errors);
            respond_internal_error($data);
            return;
        }

        if ($obj)
        {
            $this->_updateSchedules($obj, $oldReport);
            $data = array();
            $data[0] = array('reportId' => $obj->id, 'text' => $this->lang->line('advancedreports_report_save_success'),  'errorCode' => 200);
            respond_ok(json_encode($data));
            return;
        }
    }

    /**
     * This function updates the schedule queries both in MP and through rest API
     * @param  [type] $obj       [description]
     * @param  [type] $oldReport [description]
     * @return [type]            [description]
     */
    function _updateSchedules($obj, $oldReport)
    {
        // check if this report has schedules, and  NEW SQLString  is not equal to the previous SQL string
        $schedules = $obj->getSchedules();

        if (!empty($schedules) && !empty($oldReport) && ($oldReport->getSQLString() != $obj->getSQLString()))
        {
            try
            {
            // update all local and cfsettings schedules
                foreach ($schedules as $scheduleItem)
                {
                    $scheduleItem['query'] = $obj->getSQLString();

                    //update REST schedules
                    $schedObj = $this->advancedreports_model->saveScheduledReport_REST($scheduleItem);

                    // update custom_search schedules
                    $this->advancedreports_model->saveScheduleForReport($obj->id, $scheduleItem,  TRUE);
                }
            }
            catch (Exception $e)
            {
                $this->search_save_model->setError($e->getMessage(), 500);
                $errors = $this->search_save_model->getErrors();
                $data = json_encode($errors);
                respond_internal_error($data);
                return;
            }
        }
    }


    function loadreportschedules($id)
    {
        $itemLoaded = array();
        if (!empty($id))
        {
            $id = (int) html_entity_decode(rawurldecode($id));
            $filter = $this->userBasedFilter;
            $filter = $filter . " AND id = $id";

            $offset = '';
            $limit = '';
            $order = array();
            $showSchedules = 'user';
            $is_admin = isActionAllowed('reports.admin');

            if ($is_admin === TRUE)
            {
                $showSchedules = 'all';
            }

            //load report
            $itemLoaded = $this->search_save_model->get_all_search($filter, $offset, $limit, $order, $showSchedules, $is_admin);
            if(empty($itemLoaded))
            {
                $this->search_save_model->setError($this->lang->line('advancedreports_not_found'), 404);
                $errors = $this->search_save_model->getErrors();

                $data = json_encode($errors);
                if (!empty($data))
                {
                    respond_internal_error($data);
                }
                else
                {   // no schedules for this repot
                    respond_ok(json_encode(array()));
                }

                return;
            }

            $schedules = $itemLoaded[0]->getSchedules();

            respond_ok(json_encode($schedules));
        }
        else
        {
            $this->search_save_model->setError($this->lang->line('advancedreports_empty_report_name'), 406);
            $errors = $this->search_save_model->getErrors();
            $data   = json_encode($errors);
            respond_internal_error($data);

            return;
        }
    }

    /*
     * there are several options to check
     * 1- report not exist - save report + schedule
     * 2- report exist (same title) - check if query is the same
     *  a- same query - create schedule
     *  b- query was changed - overwrite report, update all queries for all scheduled reports
     *
        //variables
        reportLabel - main report title - not manddatory
        scheduleName - current schedule name
        emailFrom -
        emailTo
        scheduledTime  - time to execute as cfengine timeclass expression
        outputFileType - PDF/CSV
        outputReportTitle - will be used as email subject + (inside pdf file?)
        outputReportDescription - will be used inside pdf file?
     *
     * overwrite - overwrite or not

     */

    function savescheduleforreport()
    {
        $this->load->library(array('form_validation'));
        $this->load->model('search_save_model');

        $this->form_validation->set_rules('reportLabel', 'Report title', 'xss_clean'); // !not mandatory
        $this->form_validation->set_rules('reportCategory', 'Report category', 'xss_clean'); // !not mandatory

        $this->form_validation->set_rules('scheduleName', 'Schedule name', 'required|xss_clean');
        $this->form_validation->set_rules('scheduleTime',      'Report time',    'required|xss_clean');

        $this->form_validation->set_rules('emailFrom', 'From', 'required|xss_clean');
        $this->form_validation->set_rules('emailTo',   'To'  , 'required|valid_email');

        $this->form_validation->set_rules('outputFileType',           'Report type',       'required|xss_clean');
        $this->form_validation->set_rules('outputReportTitle',        'Report title',      'required|xss_clean');
        $this->form_validation->set_rules('outputReportDescription',  'Report decription', 'xss_clean');


        //defaults
        $timeZone = 'gmt';

        // get params
        $reportLabel  = $this->input->post('reportLabel', true);
        $reportCategory = $this->input->post('reportCategory', true);

        $scheduleName = $this->input->post('scheduleName', true);
        $scheduleTime = $this->input->post('scheduleTime', true);

        $scheduleHumanReadableTime = $this->input->post('scheduleHumanReadableTime', true);

        $emailFrom = $this->input->post('emailFrom', true);
        $emailTo   = $this->input->post('emailTo', true);
        $skipMailing   = $this->input->post('skipMailing', true);

        $outputFileType = $this->input->post('outputFileType', true);
        $outputFileType = explode(",", $outputFileType);

        $outputReportTitle       = $this->input->post('outputReportTitle', true);
        $outputReportDescription = $this->input->post('outputReportDescription', true);

        $overwrite = $this->input->post('overwrite', true);
        //cast
        $overwrite = ($overwrite == 'true' ? true: false);

        $sqlString = $this->input->post('search_params');
        $sqlString = urldecode($sqlString);

        $sharedPermissionTmp = $this->input->post('sharedPermission', false);
        $sharedPermission = $this->_formatSharedPermission(json_decode($sharedPermissionTmp));
        $is_public = $this->input->post('is_public', true);
        $is_public = (strtolower($is_public) === 'true' ? 1 :  0);
        // check if we have reports with this label, if not - create one

        $filter = $this->userBasedFilter;
        $labelFilter = sprintf("label = '%s'", $this->db->escape_str($reportLabel));
        $filter = !empty($filter) ? $filter . ' AND ' . $labelFilter : $labelFilter;

        $offset = '';
        $limit = '';
        $order = array();
        $showSchedules = 'all';
        $is_admin = isActionAllowed('reports.admin');

        $objTMP = $this->search_save_model->get_all_search($filter, $offset, $limit, $order, $showSchedules, $is_admin);

        if (!$objTMP)
        {
            $reportData = array(
                'username'      => $this->username,
                'label'         => $reportLabel,
                'url'           => 'advancedreports',
                'type'          => 'scheduled',
                'reportCategory' => $reportCategory,
                'date'          => time(),
                'params'        => $sqlString,
                'sharedPermission'    => $sharedPermission,
                'AdvancedReportsData' => $this->input->post('AdvancedReportsData', false)
            );
            $obj = $this->search_save_model->insert($reportData, $overwrite, isActionAllowed('reports.admin'));
        }
        else
        {   //label exist - get report info
            $obj = $objTMP[0]; // for compatibility with insert
        }


        // if there is no search - error
        if (!$obj)
        {
            $errors = $this->search_save_model->getErrors();

            if (empty($errors)) {
                $this->search_save_model->setError($this->lang->line('advancedreports_schedule_save_error'), 406);
                $errors = $this->search_save_model->getErrors();
            }
            $data = json_encode($errors);
            respond_internal_error($data);
            return;
        }

        //check if sql string is not equal to the saved SQL string. if so - update report and all schedules in the cfreport db via REST
        if ($obj->getSQLString() != $sqlString)
        {
            //update report - overwrite!
            $data = array(
                 'username'      => $this->username,
                 'label'         => $obj->getLabel(),
                 'date'          => time(),
                 'url'           => 'advancedreports',
                 'type'          => 'scheduled',
                 'params'        => $sqlString,
                 'sharedPermission'    => $sharedPermission,
                 'AdvancedReportsData' => $this->input->post('AdvancedReportsData', false)
            );

            $obj = $this->search_save_model->insert($data, true, isActionAllowed('reports.admin'));

            if (empty($obj))
            {
                $errors = $this->search_save_model->getErrors();
                $data = json_encode($errors);
                respond_internal_error($data);
                return;
            }

            $schedules = $obj->getSchedules();
            if(!empty($schedules))
            {
                 // check if report has schedules, and update SQL for them
                foreach ($schedules as $item)
                {
                    $item['query'] = $sqlString;

                    //update REST schedules
                    $schedObj = $this->advancedreports_model->saveScheduledReport_REST($item);

                    // update custom_search schedules
                    $this->advancedreports_model->saveScheduleForReport($obj->id, $item, TRUE);
                }
            }
        }


        // REST can not support Id as urlencoded string, so we will use mondoDB ID for it
        // also add username and time to create unique code
        $scheduleId = $obj->getId()."_".preg_replace('/[^\da-z]/i', '', $this->username)."_".time();

        // check if user alredy have schedules with the same name
        // show error if overwite is false
        if ( ($report = $this->advancedreports_model->checkIfScheduleExist($obj->id, $this->username, $scheduleName)) !== false)
        {
            if (!empty($report))
            {
                if ($overwrite === false)
                {
                    $this->search_save_model->setError($this->lang->line('advancedreports_schedule_exist_error') , 422); //422 Unprocessable Entity
                    $errors = $this->search_save_model->getErrors();
                    $data = json_encode($errors);
                    respond_internal_error($data);
                    return;
                }

                if ($report['schedulename'] == $scheduleName)
                {
                    $scheduleId = $report['id'];
                }
            }
        }

        //insert new or owerwrite previous schedule
        $scheduleData = array();

        $scheduleData['userId'] = $this->username;
        $scheduleData['id']     = $scheduleId;

        $scheduleData['title']       = $outputReportTitle;
        $scheduleData['description'] = $outputReportDescription;

        $scheduleData['emailfrom']  = $emailFrom;
        $scheduleData['emailto']    = $emailTo;
        $scheduleData['query'] = $this->input->post('search_params');
        $scheduleData['query'] = urldecode($scheduleData['query']);

        $scheduleData['schedule'] = $scheduleTime;

        $scheduleData['skipMailing'] = $skipMailing;

        $scheduleData['enabled'] = true;
        $scheduleData['outputTypes'] = $outputFileType;


        $scheduleData['hostcontextsprofileid'] = $this->input->post('hostcontextsprofileid', true);
        $scheduleData['hostcontextspath']      = $this->input->post('hostcontextspath', true);
        $scheduleData['hostcontexts']          = $this->input->post('hostcontexts', true);
        $excludes          = $this->input->post('excludedHosts', true);


        // to provide correct link for the download link
        $scheduleData['site_url'] = site_url();





        // save hostContextInclude for rest

        $scheduleData['hostContextInclude'] = array();


        if (!empty($scheduleData['hostcontexts']) && is_array($scheduleData['hostcontexts']) && isset($scheduleData['hostcontexts']['includes'])) {
            $scheduleData['hostContextInclude'] = $scheduleData['hostcontexts']['includes'];
        }

        $scheduleData['hostContextExclude'] = array();

        if (!empty($excludes) && is_array($excludes) && isset($excludes['excludes'])) {
            $scheduleData['hostContextExclude'] = $excludes['excludes'];
        }


        $schedObj = $this->advancedreports_model->saveScheduledReport_REST($scheduleData);
        unset( $scheduleData['hostContextInclude']);
        unset( $scheduleData['hostContextExclude']);



        //Multiple scheduling per report:  insert new schedule to the report schedules array
        //add additional fields to the schedule, and save them in phpmongo DB
        $scheduleData['scheduleHumanReadableTime'] = $scheduleHumanReadableTime;
        $scheduleData['scheduleName'] = $scheduleName;
        $scheduleData['excludedHosts'] = $excludes;



        $scheduleData['scheduleData'] = $this->input->post('scheduleData', false);


        try
        {
            $result = $this->advancedreports_model->saveScheduleForReport($obj->id, $scheduleData, $overwrite);
            if (!$result)
            {
                throw new Exception("Cannot insert or update schedule report");
            }

            $data = array();
            $data[0] = array('reportId' => $obj->id,'text' => $this->lang->line('advancedreports_schedule_save_success'),  'errorCode' => 200);
            respond_ok(json_encode($data));
            return;
        }
        catch (Exception $e)
        {
                // if overwrite == false, this mean that this is new query, and we should delete REST query
                if ($overwrite === FALSE)
                {
                    $schedObj = $this->advancedreports_model->deleteScheduledReport_REST($scheduleData);
                }

                if($e->getMessage())
                {
                    $this->search_save_model->setError($e->getMessage(), 406);
                }
                else
                {
                    $this->search_save_model->setError($this->lang->line('advancedreports_schedule_save_error'), 406);
                }

                $errors = $this->search_save_model->getErrors();
                $data = json_encode($errors);
                respond_internal_error($data);
                return;
        }
    }


    /**
     * This function will generate pdf, csv or both reports and send it via email.
     * This is function made for CLI execution.
     *
     * Please, don't use there direct database calls
     *
     * We receive the following params from C:
     *
     * @param string $username           - username of user who created scheduled report
     * @param string $queryId            - query name
     * @param string $sqlString          - SQL string
     * @param string $reportFileType     - string, could be pdf, csv or pdf+csv
     * @param string $reportTitle        - report title
     * @param string $reportDescription  - report description
     * @param string $emailAddressToSend - recepient email (OPTIONAL parameter)
     *
     * Example how to execute this
     * /var/cfengine/httpd/php/bin/php /var/cfengine/httpd/htdocs/index.php advancedreports generatescheduledreport admin 51dfef247fdd0bd10f000036 "select * from Hosts limit 10" csv "some_title" "description here " dmitry.shevchenko@cfengine.com "/var/cfengine/httpd/htdocs/api/static/b7817db727eae3a8a5a02c509c52a3c5.csv"
     *
     * example how it looks like from core part
     *
     * /usr/bin/php /var/cfengine/httpd/htdocs/index.php advancedreports generatescheduledreport "admin" "51b19fb9fa46347e05000001_admin_1373892910" "SELECT Hosts.HostKey AS "Host key", Hosts.HostName AS "Host name", Hosts.IPAddress AS "IP address", Hosts.ReportTimeStamp AS "Report time-stamp", Hosts.FirstReportTimeStamp AS "First report-time" FROM Hosts LIMIT 100" "(null)" "Custom report" "CFEngine SQL reports" "test@test.cas" "/var/cfengine/httpd/htdocs/tmp/admin-51b19fb9fa46347e05000001_admin_1373892910-1373894003.csv"
     *
     */

    function generatescheduledreport($queryId)
    {

        if (CLI === false) {
            $message = "You must run this action in CLI mode";
            echo $message;
            exit(1);
        }

        log_message('info', "generatescheduledreport: Start -> queryId: ". $queryId);

        $this->load->model(array('settings_model', 'pdfreports_model', 'search_save_model'));
        $this->load->library('cfe_file_reports_utils');   // include additional functions to report.

        $offset = '';
        $limit = '';
        $order = array();

        //Check for mandatory params
        if (empty($queryId)) {
            $message = 'generatescheduledreport: Query id is empty';
            log_message('error', $message);
            echo $message;
            exit(1);
        }

        $selectedSchedule = $this->search_save_model->get_schedule_by_id($queryId);

        if (empty($selectedSchedule))
        {
             $message = "generatescheduledreport: schedule with id=". htmlspecialchars($queryId) . " not found.";
             log_message('error', $message);
             echo $message;
             exit(1);
        }

        $pathToSave = trim($this->settings_model->app_settings_get_item('scheduled_reports_save_path'));
        if (empty($pathToSave))
        {
            $message = 'generatescheduledreport: Path to save reports is empty';
            log_message('error', $message);
            echo $message;
            exit(1);
        }

        // some hardcoded values for now
        $reportType = 'advancedreports'; // we use this to generate reports
        $timeZone   = 'gmt';

        $allowedReportTypes = array('pdf', 'csv');


        // Get values from db schedule, not from the function parameters

        if (isset($selectedSchedule['title']) && trim($selectedSchedule['title'])!=='')
        {
            $reportTitle = $selectedSchedule['title'];
        }
        else
        {
            $reportTitle =  "CFEngine SQL reports: $queryId";
        }


        if (isset($selectedSchedule['description']) && trim($selectedSchedule['description'])!=='')
        {
            $reportDescription = $selectedSchedule['description'];
        }
        else
        {
            $reportDescription =  '';
        }

        if (isset($selectedSchedule['outputtypes']))
        {
            $reportFileType = PgsqlArrayToPhpArray($selectedSchedule['outputtypes']);
        }
        else
        {
            $reportFileType = array('csv');
        }

        if (!empty($selectedSchedule['emailto']))
        {
            $emailAddressToSend = $selectedSchedule['emailto'];
        }
        else
        {
            $emailAddressToSend = '';
        }

        $this->reportTimeZone = $timeZone;

        $sqlString = $selectedSchedule['query'];

        //get report
        [$report] = $this->search_save_model->get_all_search(['id' => $selectedSchedule['reportid']]);

        if ($report->reportCategory != 'compliance_report' && empty($sqlString))
        {
            $message = 'generatescheduledreport: SQL string is empty';
            log_message('error', $message);
            echo $message;
            exit(1);
        }

        // check if $pathToSave is directory and we can save files to it
        $this->cfe_file_reports_utils->setStoreDir($pathToSave);
        try
        {
            $this->cfe_file_reports_utils->checkTempDir();
            $this->cfe_file_reports_utils->checkIfExistAndWritable($pathToSave);
        }
        catch (Exception $e)
        {
            log_message(log_level_for_exception($e), "generatescheduledreport: ".$e->getMessage());
            throw new Exception($e->getMessage());
            exit(1);
        }

        //prepare filename
        $filename = 'CFEngine_Enterprise_' . preg_replace('/[^-\w\d_]/', '_', $reportTitle) . "-" . date('m-d-Y-His') . '_' . random_string('alnum', 32);

        if ($report->reportCategory == 'compliance_report') {
            $this->load->model('compliance_export');
            $includes = $selectedSchedule["hostcontexts"] != '""' && $selectedSchedule["hostcontexts"] != "null" ?
                (json_decode($selectedSchedule["hostcontexts"]))->includes :
                [];
            $excludes = $selectedSchedule["excludedhosts"] != "{}" ?
                (json_decode($selectedSchedule["excludedhosts"]))->excludes :
                [];

            $reportData = $this->compliance_export->getReportData(
                $report,
                $selectedSchedule['userid'],
                $includes,
                $excludes
            );

            $tmpCSVFile = "./tmp/$filename.tmp.csv";
            log_message('info', "Generating pdf from compliance_export::generateCSV with name: " . $tmpCSVFile);
            $this->compliance_export->generateCSV($reportData, $tmpCSVFile);
        }

        // because  $tmpCSVFile  contain slashes, CI delete them, that's why we have to access this variable from server array
        $csvParamIndex = count($_SERVER['argv']);
        !isset($tmpCSVFile) && $tmpCSVFile =  $_SERVER['argv'][($csvParamIndex-1)];


        if (empty($tmpCSVFile) || (!is_file($tmpCSVFile)))
        {
            $message = 'generatescheduledreport: CSV file with data is not provided or not found';
            log_message('error', $message);
            echo $message;
            exit(1);
        }

        foreach ($reportFileType as $type)
        {
            if (!in_array($type, $allowedReportTypes))
            {
                unset($reportFileType[$type]);
            }
        }

        if (empty($reportFileType))
        {
            $message = "generatescheduledreport: Report type is not set for the report: $queryId, PDF will be used";
            log_message('error', $message);
            echo $message;
            exit(1);
        }


        if (empty($emailAddressToSend))
        {
            $message = "generatescheduledreport: There are no recepients for the report: $queryId, we will create files and save them in: $pathToSave";
            log_message('info', $message);
        }

        $linksToDownloadFile = array();
        $filesInfo = array();

        $siteUrl = $selectedSchedule['site_url'];

        $csvFile = $tmpCSVFile;


        if($selectedSchedule['skipmailing'] === true && $this->pdfreports_model->getRowsCount($csvFile) === 0){
            $message = "generatescheduledreport: Report was skipped, because of 0 records." ;
            log_message('info', $message);
            echo $message;
            exit(1);
        }

        $path    = base64_encode($pathToSave);
        $attachmentSize = 0;
        // CSV should go first
        if (in_array('csv',$reportFileType))
        {
            //rename file
            $file = $filename . '.csv';

            $sourceFile = $tmpCSVFile;
            $destFile   = $pathToSave . $file;
            $csvFile    = $destFile; // save renamed files as a source
            $linksToDownloadFile['csv'] = $siteUrl . "/pdfreports/download/file/$file/path/$path/action/downloadLocal";
            if (!copy($sourceFile, $destFile))
            {
                $message = "generatescheduledreport: CSV->failed to copy $sourceFile to $destFile";
                log_message('error', $message);
                echo $message;
                exit(1);
            }
            $filesInfo['csv'] = $this->pdfreports_model->checkFileSize($file);
            $attachmentSize = $filesInfo['csv'] ? $filesInfo['csv']['fileSize'] + $attachmentSize : $attachmentSize;

            $this->changeFileOwner($destFile);
        }

        if (in_array('pdf', $reportFileType))
        {
            // generate PDF file
            $reportID    = 'advancedreports';
            $baseCsvFile = $csvFile; // use renamed file as source
            $file = $filename . '.pdf';

            try
            {
                if ($report->reportCategory == 'compliance_report') {
                    log_message('info', "Generating pdf from compliance_export::generatePDF with name: " . $file);
                    $this->compliance_export->generatePDF($reportData, $filename, $reportTitle, $reportDescription);
                } else {
                /*
                 * filename - will be used to create log and pid file with this name
                 */
                    log_message('info', "Generating pdf from scheduled csv file with name: ".$file);
                    $this->pdfreports_model->convertCSVtoPDF(
                        $filename,
                        $baseCsvFile,
                        $reportID,
                        $reportTitle,
                        $reportDescription,
                        $filename,
                        $pathToSave
                    );
                }

                $linksToDownloadFile['pdf'] = $siteUrl . "/pdfreports/download/file/$file/path/$path/action/downloadLocal";
            }
            catch (Exception $e)
            {
                $message = "generatescheduledreport: PDF->".$e->getMessage();
                log_message('error', $message);
                echo $message;
                exit(1);
            }
            $filesInfo['pdf'] = $this->pdfreports_model->checkFileSize($file);
            $attachmentSize = $filesInfo['pdf'] ? $filesInfo['pdf']['fileSize'] + $attachmentSize : $attachmentSize;
        }

        $this->load->model('MailSettingsModel');

        $this->MailSettingsModel->getSetting('max_email_attach_size');

       $isCanBeAttached = $attachmentSize < $this->MailSettingsModel->getSetting('max_email_attach_size') ? true : false;

        if(!empty($emailAddressToSend))
        {
            $to      = $emailAddressToSend;
            $from    = trim($this->settings_model->app_settings_get_item('appemail'));
            $subject = 'CFEngine scheduled report "'.$reportTitle.'"';

            $msg     = 'Your scheduled report "'.$reportTitle.'" is generated at '.getDateStatus(time(), true, true, $timeZone);
            if(!$isCanBeAttached){
                $this->load->helper('url');

                $dataToReplace = [
                    'attachmentSize' => round($attachmentSize),
                    'currentlySettingsSize' =>  $this->MailSettingsModel->getSetting('max_email_attach_size'),
                    'settingsUrl' => $siteUrl . '/settings/mail'
                ];

                $msg  .=  vsprintf(' was too large (%s MB) to attach to the email. You can adjust the maximum email attachment size (currently %s MB) in Settings: %s or use the link provided below to download the report.', $dataToReplace);
            }
            $msg    .= "\n";
            $msg    .= !empty($reportDescription) ? 'Description: "'.$reportDescription.'"'. "\n" : '';

            $filesToAttach = [];
            if($isCanBeAttached){
                $filesToAttach = array_map(function($info){ return $info['filePath'];}, $filesInfo);
            }else{
                $txt    = (count($linksToDownloadFile) == 1 ? 'file': 'files');
                $msg    .= "\n". '------ Please use the link below to download the '.$txt.' -----'."\n";
                foreach ($linksToDownloadFile as $itemType => $link)
                {
                    $msg .= strtoupper($itemType) .": ".$link ."\n";
                }
            }

            try
            {
                $message = $this->cfe_file_reports_utils->emailReport($to, $from, $subject, $msg, $filesToAttach);
            }
            catch(Exception $e)
            {
                $message = "generatescheduledreport: ".$e->getMessage();
                log_message('error', $message);
                echo $message;
                exit(1);
            }
        }

        exit(0);
    }

    /**
     * @param $relativePath
     *
     * Change scheduled report file owner to cfapache to be able to download report
     */
    private function changeFileOwner($relativePath)
    {
        $file = realpath(FCPATH . $relativePath);
        if (file_exists($file)) {
            $apacheUser = $this->config->item('notification_script_user');
            chown($file, $apacheUser);
        }
    }

    /*TODO: refactor once we get rid from old report functionality*/
    function delete($id = '')
    {
        $id = html_entity_decode(rawurldecode($id));
        $id = trim($id);

        if (empty($id))
        {
            $this->search_save_model->setError($this->lang->line('advancedreports_report_id_empty'), 406);
            $errors = $this->search_save_model->getErrors();

            $data = json_encode($errors);
            respond_internal_error($data);
            return;
        }

        $filter['id'] =  $id;

        $is_admin = isActionAllowed('reports.admin');
        if ($is_admin !== TRUE)
        {
           $filter['username'] = $this->db->escape_str($this->username);
        }


        $offset = '';
        $limit = '';
        $order = array();
        $showSchedules = 'all';


        $itemLoaded = array();
        $itemLoaded = $this->search_save_model->get_all_search($filter, $offset, $limit, $order, $showSchedules, $is_admin);

        if (empty($itemLoaded))
        {
            $this->search_save_model->setError($this->lang->line('advancedreports_report_not_found'), 406);
            $errors = $this->search_save_model->getErrors();
            $data   = json_encode($errors);
            respond_internal_error($data);
            return;
        }

        // delete related schedules from cfreport
        $schedules = $itemLoaded[0]->getSchedules();

        if (!empty($schedules))
        {
            foreach ($schedules as $item)
            {
                try
                {
                    $schedData = array();
                    $schedData['userId'] = $item['userId'];
                    $schedData['id']     = $item['id'];

                    $schedObj = $this->advancedreports_model->deleteScheduledReport_REST($schedData);
                }
                catch (Exception $e)
                {
                    $this->search_save_model->setError($this->lang->line('advancedreports_schedule_delete_error'), 406);
                    $errors = $this->search_save_model->getErrors();
                    $data = json_encode($errors);
                    respond_internal_error($data);
                    return;
                }
            }
        }


        $result = $this->search_save_model->delete($filter);

        if (!$result)
        {
            $this->search_save_model->setError($this->lang->line('advancedreports_report_delete_error'), 406);
            $errors = $this->search_save_model->getErrors();
            $data   = json_encode($errors);
            respond_internal_error($data);
            return;
        }

        $data = array();
        $data[0] = array('text' => $this->lang->line('advancedreports_report_delete_success'),  'errorCode' => 200);
        respond_ok(json_encode($data));
    }



    function deleteschedule()
    {
        $reportId   = (int) $this->input->post('reportId', true);
        $scheduleId = $this->input->post('scheduleId', true);

        $is_admin = isActionAllowed('reports.admin');
        $roles = $this->getUserRoles($this->username);


        // check if user has rights to delete schedules from reports
        $filter = $this->search_save_model->_getAllAvailableReportsFilter($is_admin, $roles);
        $filter .= !empty($filter) ? " AND id=$reportId " : "id=$reportId" ;

        if (isActionAllowed('reports.admin') !== TRUE)
        {
           $showSchedules = 'user';
           $is_admin = false;
        }
        else
        {
            $showSchedules = 'all';
            $is_admin = TRUE;
        }


        $offset = '';
        $limit = '';
        $order = array();

        // check if report exists
        $itemLoaded = array();
        $itemLoaded = $this->search_save_model->get_all_search($filter, $offset, $limit, $order, $showSchedules, $is_admin);

        if (empty($itemLoaded))
        {
            $this->search_save_model->setError($this->lang->line('advancedreports_schedule_delete_error'), 406);
            $errors = $this->search_save_model->getErrors();
            $data   = json_encode($errors);
            respond_internal_error($data);
            return;
        }

        // check if there any schedules created by this user
        if ($is_admin == TRUE)
        {
            $schedules = $itemLoaded[0]->getSchedules();
        }
        else
        {
            $schedules = $this->search_save_model->_getSchedulesByUser($itemLoaded[0]->getSchedules(),  $this->username);
        }

        if (empty($schedules))
        {
            $this->search_save_model->setError($this->lang->line('advancedreports_schedule_delete_error'), 406);
            $errors = $this->search_save_model->getErrors();
            $data   = json_encode($errors);
            respond_internal_error($data);
            return;
        }

        // check if report exists
        $scheduleToDelete = array();
        $found = false;
        foreach($schedules as $schedule)
        {
            if($schedule['id'] === $scheduleId)
            {
                $found = TRUE;
                $scheduleToDelete = $schedule; // remeber what we should delete
                break;
            }
        }

        if ($found !== TRUE)
        {
            $this->search_save_model->setError($this->lang->line('advancedreports_schedule_delete_error'), 406);
            $errors = $this->search_save_model->getErrors();
            $data   = json_encode($errors);
            respond_internal_error($data);
            return;
        }

        // delete schedule from cfreports
        try
        {
            // prepare data
            $scheduledData = array();
            // admin should be able to delete any schedule
            // we have to replace userid to the schedule userid for admin to make this work
            // if not admin - real username will be used,

            if ($is_admin == TRUE)
            {
                $scheduledData['userId'] = $scheduleToDelete['userId'];
            }
            else
            {
                $scheduledData['userId'] = $this->username;
            }

            $scheduledData['id']     = $scheduleId;

            //delete from cfreport
            $obj = $this->advancedreports_model->deleteScheduledReport_REST($scheduledData);
            // delete schedule from phpcfengine
            $obj = $this->advancedreports_model->deleteSchedule($reportId, $scheduleId);

            $data[0] = array('text' => $this->lang->line('advancedreports_schedule_delete_success'),  'errorCode' => 200);
            respond_ok(json_encode($data));
        }
        catch (Exception $e)
        {
            $this->search_save_model->setError($this->lang->line('advancedreports_schedule_delete_error'), 406);
            $errors = $this->search_save_model->getErrors();
            $data = json_encode($errors);
            respond_internal_error($data);
            return;
        }
    }

    /**
     * Load partials
     *
     * @param type $partial - name of the view
     */
    function partials($partial)
    {
        $view = 'partials/' . $partial . '.php';
        $this->load->view($view);
    }

    /**
     * Load partials
     *
     * @param type $partial - name of the view
     */
    function hostDiagnosticView($type)
    {
        $this->username = $this->session->userdata('username');
        $this->load->model('health_diagnostic_model');
        $data = $this->health_diagnostic_model->getReportData($type);
        $data['type'] = $type;
        $view = 'partials/healthDiagnostic.php';
        $this->load->view($view, $data);
    }


    /**
     * This function expect base 64 encoded SQL query string, and  will redirect user to the report/external action in angular.
     * which will try to decode data and run query
     *
     *
     * @param type $base64EncodedQuery - base 64 encoded SQL query string
     */
    function external()
    {
        $get = $this->uri->uri_to_assoc();

        $base64EncodedQuery   = $get['sql'];

        $base64EncodedInludes = !empty($get['includes']) ? $get['includes'] : null;
        $title = !empty($get['title']) ? $get['title'] : null;
        $delview = !empty($get['delview']) ? '&delview=1' : '';

        if (empty($base64EncodedQuery))
        {
            redirect('reports/index');
        }

        if (!empty($base64EncodedInludes))
        {
            $includeUrl = '&includes='.$base64EncodedInludes;
        }
        else $includeUrl= '';


        $titleUrl  = '';
        if (!empty($title))
        {
            $titleUrl = '&title='.urlencode($title);
        }

        redirect('reports/report/external/?sql=' . $base64EncodedQuery.$includeUrl.$titleUrl.$delview); //default action
    }


    private function getAllAvailableUserRoles()
    {
        try {
            $roles = array_map(function ($item) {
                return $item['id'];
            }, $this->ion_auth->get_roles());
        } catch (HttpClient_Forbidden $e) {
            // if error listing roles just list the roles the use currently has
            $roles = $this->session->userdata('roles') ? $this->session->userdata('roles') : array();
        }
        return $roles;
    }

    public function getUserRoles($username)
    {
        return $this->ion_auth->get_user_rolelist($username);
    }

    /**
     * Convert  roles from object to array and keep roles which available to user
     *
     * @param type $obj
     * @return type
     */

    function _formatSharedPermission($obj)
    {
        $result = array();

        $roles = $this->getAllAvailableUserRoles();

        if (!empty($obj))
        {
            foreach ($obj as $field => $value)
            {
                if ($value === TRUE && in_array($field, $roles))
                {
                    $result[] = $field;
                }
            }
        }
        return $result;
    }



    function subscribe()
    {
        $reportId = $this->input->post('reportId', true);

        if(empty($reportId))
        {
                $this->search_save_model->setError($this->lang->line('advancedreports_report_id_empty'), 404);
                $errors = $this->search_save_model->getErrors();

                $data = json_encode($errors);
                respond_internal_error($data);

                return;
        }

        $is_admin = isActionAllowed('reports.admin');
        $roles = $this->getUserRoles($this->username);

        $result = $this->search_save_model->subscribeToReport($reportId, $this->username, $roles, $is_admin);

        if ($result === FALSE)
        {
            $errors = $this->search_save_model->getErrors();
            $data   = json_encode($errors);
            respond_internal_error($data);
            return;
        }
        else
        {
            $data[0] = array('text' => $this->lang->line('advancedreports_subscribe_success'),  'errorCode' => 200);
            respond_ok(json_encode($data));
            return;
        }
    }



    function unsubscribe()
    {
        $reportId = (int)$this->input->post('reportId', true);

        if(empty($reportId))
        {
                $this->search_save_model->setError($this->lang->line('advancedreports_report_id_empty'), 404);
                $errors = $this->search_save_model->getErrors();

                $data = json_encode($errors);
                respond_internal_error($data);

                return;
        }

        $is_admin = isActionAllowed('reports.admin');

        $result = $this->search_save_model->unSubscribeFromReport($reportId, $this->username, $is_admin);

        if ($result === FALSE)
        {
            $errors = $this->search_save_model->getErrors();
            $data   = json_encode($errors);
            respond_internal_error($data);
            return;
        }
        else
        {
            $data[0] = array('text' => $this->lang->line('advancedreports_unsubscribe_success'), 'errorCode' => 200);
            respond_ok(json_encode($data));
            return;
        }
    }

    function copyReport()
    {
        $reportId    = $this->input->post('reportId',    true);
        $reportLabel = $this->input->post('reportLabel', true);
        $reportCategory = $this->input->post('reportCategory', true);

        $sharedPermissionTmp = $this->input->post('sharedPermission', false);
        $sharedPermission = $this->_formatSharedPermission(json_decode($sharedPermissionTmp));

        $is_public = $this->input->post('is_public', true);
        $is_public = (strtolower($is_public) === 'true' ? '1': '0');

        $overwrite = $this->input->post('overwrite', true);

        //cast
        $overwrite = ($overwrite == 'true' ? true: false);


        if (empty($reportId))
        {
            $this->search_save_model->setError($this->lang->line('advancedreports_report_id_empty'), 406);
        }
        elseif (empty($reportLabel))
        {
            $this->search_save_model->setError($this->lang->line('advancedreports_empty_report_name'), 406);
        }

        $errors = $this->search_save_model->getErrors();
        if (!empty($errors))
        {
            $data   = json_encode($errors);
            respond_internal_error($data);
            return;
        }

        // in the "clone" user should be able to see same reports as on all searches page,
        $is_admin = isActionAllowed('reports.admin');
        $roles    = $this->getUserRoles($this->username);

        $data = array();
        $data['reportId']         = $reportId;
        $data['reportLabel']      = $reportLabel;
        $data['reportCategory']   = $reportCategory;
        $data['sharedPermission'] = $sharedPermission;
        $data['is_public']        = $is_public;

        $obj = $this->search_save_model->copyReport($data, $this->username, $roles, $is_admin, $overwrite);

        if (!$obj) //not able to insert
        {
            $errors = $this->search_save_model->getErrors();
            $data   = json_encode($errors);
            respond_internal_error($data);
            return;
        }
        else
        {
            $data    = array();
            $data[0] = array('reportId' => $obj->id, 'text' => $this->lang->line('advancedreports_report_copy_success'),  'errorCode' => 200);
            respond_ok(json_encode($data));
            return;
        }
  }

    /**
     *  Clean up result data for list report pages
     *
     *
     */
    function _removeLegacyDataFromReportList($reports)
    {
        if (empty($reports))
        {
            return array();
        }

        //unset variables which we don't need for report listing
        $tmpArray = array();

        foreach ($reports as $item => $report)
        {
            $tmpArray[$item] = (array)$report;
            unset($tmpArray[$item]['params']);
            unset($tmpArray[$item]['AdvancedReportsData']);
            unset($tmpArray[$item]['SQLString']);
            unset($tmpArray[$item]['schedules']);
            unset($tmpArray[$item]['type']);
            unset($tmpArray[$item]['reportType']);
            unset($tmpArray[$item]['date']);
            unset($tmpArray[$item]['sharedPermission']);
            unset($tmpArray[$item]['sharedBy']);
            unset($tmpArray[$item]['details']);
            unset($tmpArray[$item]['site_url']);
        }

        return $tmpArray;
    }

    function changes()
    {

        $data   = $this->input->post();
        //$data['timerange'] = $this->session->userdata('timerange');
        try
        {
            $result = $this->advancedreports_model->runChangeQuery($data);
            respond_ok(json_encode($result));
        }
        catch (HttpClient_BadRequest $e)
        {
            respond_not_acceptable($e->getMessage());
        }
        catch (Exception $e)
        {
            $message = $e->getMessage();
            log_message('debug', 'Failed retrieving alerts, error: ' . $message);
            respond_internal_error($message);
        }
    }

    function changescount()
    {
        $data   = $this->input->post();
        try
        {
            $result = $this->advancedreports_model->runChangeCount($data);
            respond_ok(json_encode($result));
        }
        catch (Exception $e)
        {
            $message = $e->getMessage();
            log_message('debug', 'Failed retrieving alerts, error: ' . $message);
            respond_internal_error($message);
        }
    }

    function hostCount()
    {
        $data   = $this->input->post();
        try
        {
            $result = $this->advancedreports_model->getHostCount($data);
            respond_ok($result);
        }
        catch (Exception $e)
        {
            $message = $e->getMessage();
            log_message('debug', 'Failed retrieving alerts, error: ' . $message);
            respond_internal_error($message);
        }
    }

    public function decommissionedHostCount()
    {
        try {
            $data = $this->input->post();
            $this->load->model('dashboard/decommissioned_hosts_model');
            $result = $this->decommissioned_hosts_model->getDecommissionedHostCount($data['from'], $data['to'], $data['period']);
            respond_ok(json_encode($result));
        } catch (Exception $e) {
            $message = $e->getMessage();
            log_message('debug', 'Failed retrieving alerts, error: ' . $message);
            respond_internal_error($message);
        }
    }




    function getinventoryfields()
    {
        try
        {
            $obj = $this->advancedreports_model->getInventoryFields($this->username);

            if (!$obj) //not able to insert
            {
                $errors = $this->advancedreports_model->getErrors();
                $data = json_encode($errors);
                respond_internal_error($data);
                return;
            }

            respond_ok(json_encode($obj));
            return;
        }
        catch (Exception $e)
        {
            $message = $e->getMessage();
            log_message('debug', 'Failed retrieving alerts, error: ' . $message);
            respond_internal_error($message);
        }
    }

    function updatevariablesdictionary()
    {
        $json = $this->input->post('fields', true);
        $data = json_decode($json, true);


        $this->load->model("variables_dictionary_model");
        try
        {
            $this->variables_dictionary_model->updateVariables($data);
        }
        catch (Exception $e)
        {
            $message = $e->getMessage();
            log_message('debug', 'updatevariablesdictionary() : ' . $message);
            respond_internal_error($message);
        }

        $data[0] = array('text' => $this->lang->line('variables_dictionary_updated'), 'errorCode' => 200);
        respond_ok(json_encode($data));
        return;
    }

    function goToBootstrappedHostsReport()
    {
        try
        {
            $data = $this->advancedreports_model->getBootstrappedHostReportId();
            $id = isset($data['id']) ? $data['id'] : 1;
            redirect('/reports/report/run/'.$id.'/');
        }
        catch (Exception $e)
        {
            $message = $e->getMessage();
            log_message('debug', 'Failed retrieving alerts, error: ' . $message);
            respond_internal_error($message);
        }
    }

    public function goNotKeptReport()
    {
        try {
            $data = $this->advancedreports_model->getNotKeptReportId();
            if (isset($data['id'])) {
                redirect('/reports/report/run/' . $data['id'] . '/');
            } else {
                $message = "'Promises not kept (failed) that have not been kept or repaired' report doesn't exist";
                log_message('debug', $message);
                respond_not_found($message);
            }
        } catch (Exception $e) {
            $message = $e->getMessage();
            log_message('debug', 'Failed redirecting to not kept report, error: ' . $message);
            respond_internal_error($message);
        }
    }

    public function notKeptNotRepairedCount()
    {
        try {
            $data = $this->input->post();
            $this->load->model('dashboard/not_kept_promises_model');
            $result = $this->not_kept_promises_model->getNotKeptCount($data['from'], $data['to'], $this->username);
            respond_ok(json_encode($result));
        } catch (Exception $e) {
            $message = $e->getMessage();
            log_message('debug', 'Failed retrieving not kept stats, error: ' . $message);
            respond_internal_error($message);
        }
    }

    public function renderTable($type, $hostkey)
    {
        $data = [];
        switch ($type) {
            case 'classes':
                $data = $this->advancedreports_model->getClassesByHostkey($this->username, $hostkey);
                $pinType = 'class';
                break;
            case 'variables':
                $data = $this->advancedreports_model->getVariablesByHostkey($this->username, $hostkey);
                $pinType = 'variable';
                break;
            case 'inventory':
                $data = $this->advancedreports_model->getInventoriesByHostkey($this->username, $hostkey);
                $pinType = 'inventory';
                break;
        }
        $this->load->view('advancedreports/partials/modal_table', ['data' => $data, 'type' => $pinType]);
    }

    public function compliance_report($action)
    {

        $this->load->view('advancedreports/partials/compliance_report/' . $action);
    }

    public function open_rule_report($type, $id, $reportId)
    {
        $this->load->model(['dashboard/rules_model', 'assets_model', 'search_save_model']);
        $url = '/reports/report/run?state=';

        $report = $this->search_save_model->get_all_search($filter = ['id' => $reportId], $offset = 0, $limit = 1);

        $reportObject = (isset($report[0]) && is_a($report[0], CF_Search::class)) ? $report[0] : null;

        $rule = $this->rules_model->get_rules_with_ids([intval($id)]);
        if(sizeof($rule) > 0) {
           $sql = $this->rules_model->getResultSQL($rule[0], $this->username);
           $url .= rawurlencode(
               base64_encode(json_encode($this->assets_model->getComplianceReportParams($sql, $rule[0], $type, $reportObject)))
           );
           $url .= '&title=' . $rule[0]->name . ' / ' . $type;
        }

        header('Location: '. site_url($url));
        exit;
    }

    public function report_by_export_id($exportId)
    {
        $filter = ['export_id' => $exportId, 'username' => $this->username];
        $reports = $this->search_save_model->get_all_search($filter, $offset = 0, $limit = 1);

        if (sizeof($reports) == 1) {
            respond_ok(json_encode($reports[0]));
        } else {
            respond_not_found();
        }
    }
}
