'use strict';

/* Filters */
reports.filter('urlEncode', function() {
    return function(input) {
        return encodeURIComponent(input);
    };
});



reports.filter('showEnvironmentFilter', ['commonHelper',  function(commonHelper) {
    return function(data) {
       var result = '';

       if (data !== undefined && data !== null)
       {
            // profile from dropdown
            if (data.name !== undefined &&  data.name !== '')
            {
                result = data.name;
            }
            // from user input
            else if (data.includes !==  undefined && data.includes !== '')
            {
                result = data.includes[0];
            }
       }
       return result;
    };
}]).filter('convertReportCategories', function() {
    return function( input) {
        var output = input;
        if (input) {
            // hack
            if (input === 'inventory') {
                return "Inventory";
            }

            input = input.toString();
            angular.forEach(ReportCategories, function(data, index) {
                if (data.value === input) {
                    output = data.label;
                }
            });
        }
        return output;
    };
});

/**
 *  truncateString string by length
 *
 * {{some_text | truncateString:true:100:' ...'
 *   wordwise (boolean) - if true, cut only by words bounds,
 *   max (integer) - max length of the text, cut to this number of chars,
 *   tail (string, default: ' …') - add this string to the input string if the string was cut.
 *
 *   @param {object} commonHelper referense to the helper
 */
reports.filter('truncateString', ['commonHelper', function (commonHelper) {
        return function (value, wordwise, max, tail) {
            return commonHelper.truncateString(value, wordwise, max, tail);
        };
    }]);

    reports.filter('getColumnType', [function() {
        return function(value, fieldsArray, title) {

            // ugly way of finding what type of data we show - match by title
            var type = '';
            angular.forEach(fieldsArray, function(field, id) {
                if (field && field.label === title && type === '') {
                    type = field.type;
                    return;
                }
            });
            return type;
        };
    }]);

/**
 * Return conditions which are applicable to the field dataType
 */
reports.filter('filterConditionsByDataType', [function() {
        return function(conditions, field) {
            var result = [];
            angular.forEach(conditions, function(conditionItem, index) {
                if ($.inArray(field.dataType, conditionItem.dataType) !== -1) {
                    result.push(conditionItem);
                }
            });
            return result;
        };
    }]);
