const rbac = (function (storage) {
    const storageItemKey = 'rbacPermissions';
    let allowedActions = [];

    const fetchPermissions = async () => {
        try {
            return await (await fetch('/rbac_api/allowed_permissions')).json();
        } catch (error) {
            console.error('Failed to fetch allowed permissions:', error);
            return [];
        }
    }
    
    async function initializePermissions() {
        if (!storage.getItem(storageItemKey)) {
            allowedActions = await fetchPermissions();
            storage.setItem(storageItemKey, JSON.stringify(allowedActions));
        } else {
            allowedActions = JSON.parse(storage.getItem(storageItemKey));
        }
    }

    return {
        /**
         * Check if an action is allowed
         * @param {string} action - The action to check
         * @returns {Promise<boolean>} - Promise that resolves to true if the action is allowed, false otherwise
         */
        isActionAllowed: async action => {
            await initializePermissions();
            return allowedActions.includes(action);
        }
    };
})(localStorage);
