const CmdbSuggestions = [
    {
        "name": "Evaluate policy every minute",
        "tooltip": "cf-execd will have a schedule of any, meaning it starts the agent every minute when it wakes up, and with a delay of 0 to 1 minute (splay time).",
        "variables": {
            "default:def.control_executor_splaytime": {
                "value": "1",
                "comment": "All hosts shouldn't run their policy at the exact same time. They are spread out over this interval (in minutes). Note: Should be updated together with schedule.",
                "tags": ["suggestion-001"]
            },
            "default:def.control_executor_schedule": {
                "value": ["any"],
                "comment": "Every minute, CFEngine uses the schedule to determine whether it should evaluate policy. Thus, a schedule of \"any\" means every minute. Note: Should be updated together with splaytime.",
                "tags": ["suggestion-001"]
            }
        }
    },
    {
        "name": "Enable monitoring data for non-hubs",
        "variables": {
            "default:def.default_data_select_host_monitoring_include": {
                "value": [".*"],
                "comment": "What monitoring data hosts should report to the hub. Note: For monitoring data to work, you must set this on both the hub and the host(s) you want data from.",
                "tags": ["suggestion-002"]
            }
        }
    },
    {
        "name": "Enable autorun",
        "classes": {
            "default:services_autorun": {
                "comment": "Automatically evaluate bundles tagged with autorun.",
                "tags": ["suggestion-003"]
            }
        }
    },
    {
        "name": "Add policy files to inputs",
        "variables": {
            "default:def.augment_inputs": {
                "value": [],
                "comment": "Add filenames to this list to make the CFEngine agent parse them. Note: Update the bundle sequence to evaluate bundles from these policy files.",
                "tags": ["suggestion-004"]
            }
        }
    },
    {
        "name": "Add policy bundles to the evaluation bundle sequence",
        "variables": {
            "default:def.control_common_bundlesequence_end": {
                "value": [],
                "comment": "Add policy bundles you want evaluated to this list. Note: The bundles must be in policy files already added to inputs.",
                "tags": ["suggestion-005"]
            }
        }
    },
    {
        "name": "Automatically install dependencies for Federated Reporting",
        "only": "hub",
        "classes": {
            "default:cfengine_mp_fr_dependencies_auto_install": {
                "comment": "If semanage is not installed, install it automatically as it's needed for Federated Reporting to work.",
                "tags": ["suggestion-006", "report"]
            }
        }
    },
    {
        "name": "Collect reports every minute",
        "tooltip": "Sets the CFEngine hub's schedule such that it connects to hosts and collects new reporting data every minute.",
        "only": "hub",
        "variables": {
            "default:control_hub_hub_schedule": {
                "value": ["any"],
                "comment": "Every minute, CFEngine uses the schedule to determine whether it should collect reports. Thus, a schedule of \"any\" means every minute.",
                "tags": ["suggestion-007"]
            }
        }
    },
    {
        "name": "Disable recommendation log messages",
        "tooltip": "Disable the built-in warnings / recommendations about changes in behavior, PostgreSQL config, installing particular binaries, etc.",
        "classes": {
            "default:cfengine_recommendations_disabled": {
                "comment": "Disable recommendations policy.",
                "tags": ["suggestion-008"]
            }
        }
    }
]
