<?php

class CF_Search {

    var $username;
    var $reportType;
    var $url;
    var $label;
    var $reportCategory;
    var $date;
    var $id;
    var $params;
    var $AdvancedReportsData;
    var $schedules;
    var $type;
    var $promise_filter;
    var $details;

    var $is_own;
    var $can_edit;
    var $can_delete;
    var $can_subscribe;
    var $is_subscribed;


    var $hasSchedules;
    var $totalSchedules;
    var $ownSchedules;
    var $showScheduleStatistic;


    var $readonly;
    var $is_public;

    var $sharedPermission;
    var $sharedBy;

    //used in schedule to provide correct link to the MP insance
    var $site_url;

    function __construct($params=array()) {
        $this->id         = isset($params['id'])         ? $params['id'] : null;
        $this->username   = isset($params['username'])   ? $params['username']          : null;
        $this->url        = isset($params['url'])        ? $params['url']               : null;
        $this->reportType = isset($params['reporttype']) ? $params['reporttype']        : null;
        $this->label      = isset($params['label'])      ? $params['label']             : null;
        $this->reportCategory   = isset($params['reportcategory'])   ? $params['reportcategory']          : null;
        $this->date       = isset($params['date'])       ? $params['date']              : null;
        $this->params     = isset($params['params'])     ? $params['params']            : null;
        $this->AdvancedReportsData = isset($params['advancedreportsdata']) ? json_decode($params['advancedreportsdata'],true) : null;
        $this->SQLString  = isset($params['advancedreportsdata']['SQL']) ? $params['advancedreportsdata']['SQL'] : null;

        $this->schedules  = isset($params['schedules']) ? $params['schedules'] : null;

        $this->type = isset($params['type']) ? $params['type']        : null;

        $this->readonly  = isset($params['readonly']) ? $params['readonly']  : null;
        $this->is_public = isset($params['is_public'])? $params['is_public']    : null;

        $this->params           = isset($params['params'])             ? $params['params']            : null;
        $this->promise_filter   = isset($params['promise_filter'])     ? $params['promise_filter']    : null;

        $this->details    = isset($params['details'])    ? $params['details']           : null;

        $this->site_url   = isset($params['site_url'])   ? $params['site_url']          : null;

        $this->sharedPermission = isset($params['sharedpermission']) ? PgsqlArrayToPhpArray($params['sharedpermission'])  : array();
        $this->sharedBy         = isset($params['sharedby'])         ? PgsqlArrayToPhpArray($params['sharedby'])          : array();



        $this->is_own         = isset($params['is_own'])        ? $params['is_own']         : null;
        $this->can_edit       = isset($params['can_edit'])      ? $params['can_edit']       : null;
        $this->can_delete     = isset($params['can_delete'])    ? $params['can_delete']     : null;
        $this->can_subscribe  = isset($params['can_subscribe']) ? $params['can_subscribe']  : null;
        $this->is_subscribed  = isset($params['is_subscribed']) ? $params['is_subscribed']  : null;


        $this->hasSchedules   = isset($params['hasSchedules'])     ? $params['hasSchedules']   : null;
        $this->totalSchedules = isset($params['totalSchedules'])   ? $params['totalSchedules'] : null;
        $this->ownSchedules   = isset($params['ownSchedules'])     ? $params['ownSchedules']   : null;

        $this->showScheduleStatistic   = isset($params['showScheduleStatistic'])     ? $params['showScheduleStatistic']   : null;
        $this->export_id = $params['export_id'] ?? null;
        $this->meta_data = isset($params['meta_data']) ? json_decode($params['meta_data'],true) : null;
    }

    function getUsername() {
        return $this->username;
    }

    function getUrl() {
        return $this->url;
    }


    function getDate() {
        return getDateStatus($this->date,true,true);
    }

    function getReportType() {
        return $this->reportType;
    }

    function getLabel() {
        return $this->label;
    }

    function getReportCategory() {
        return $this->reportCategory;
    }

    function getReadonly() {
        return $this->readonly;
    }

    function getIsPublic() {
        return $this->is_public;
    }

    function getId() {
        return (int)$this->id;
    }
    /**
     * Returns the parameter form the url that is constructed
     * return @array with key as parameter and value as the searched value, if nothing returns empty array
     */
    function getParameters() {
        $params = $this->params;
        return $params;
    }

    function getAdvancedReportsData() {
        $AdvancedReportsData = $this->AdvancedReportsData;
        return $AdvancedReportsData;
    }

    function getSQLString() {
        $SQLString = $this->params;
        return $SQLString;
    }

    function getSchedules() {
        return $this->schedules;
    }

    function getType() {
        return $this->type;
    }

    function getDetails(){
        $details=$this->details ;
        if($details==null){
            return array();
        }else{
          return json_decode($details);
        }
    }

    function getPromiseFilter(){
        return $this->promise_filter;
    }

    /*
     * Used in scheduled report - provide correct link to the MP
     */
    function getSiteUrl() {
        return $this->site_url;
    }

    function getSharedPermission()
    {
        return $this->sharedPermission;
    }

    function getSharedBy()
    {
        return $this->sharedBy;
    }
}
