<?php

$secretsIniPath = realpath(__DIR__ . '/../../../secrets.ini');
$secrets = [];
if (file_exists($secretsIniPath)) {
    $secrets = parse_ini_file(realpath(__DIR__ . '/../../../secrets.ini'));
}

const APP_NAME = 'Mission Portal';
/*
CONFIGURABLE VALUES FOR OAUTH
 */
define('OAUTH_DATABASE_NAME', 'cfsettings');
define('CFDB_DATABASE_NAME', 'cfdb');
define('CFMP_DATABASE_NAME', 'cfmp');
define('OAUTH_DATABASE_PORT', 5432);
define('OAUTH_DATABASE_HOST', '/tmp');
define('OAUTH_DATABASE_USER', 'cfpostgres');
define('OAUTH_DATABASE_PASS', null);
define('OAUTH_REFRESHTOKEN_TIME', 86400);
define('OAUTH_ACCESSTOKEN_TIME', 60 * 60 * 24); // default access tokens expiration time = 1 day
define('LDAP_API_SECRET_KEY', $secrets['ldap_api_secret'] ?? null);
define('LDAP_API_URL', 'https://127.0.0.1/ldap');
define('POLICY_PATH', '/opt/cfengine/analyzer/policy/masterfiles');
define('CF_RUN_AGENT_SOCKET', '/var/cfengine/state/cf-execd.sockets/runagent.socket');
define('BUILD_MODULES_URL', 'https://build.cfengine.com/js/modules.json');
define('USER_AGENT', 'CFEngine Enterprise API');
define('MP_CLIENT_SECRET', $secrets['mp_client_secret'] ?? null);


define('SSH_DIGEST_ALGORITHM', 'sha512');
define('SSH_PRIVATE_KEY_BITS', 4096);
define('SSH_PRIVATE_KEY_TYPE', OPENSSL_KEYTYPE_RSA);


define('CMDB_PATH', realpath(__DIR__ . '/../../../../cmdb/'));
define('CACHE_DIRECTORY_PATH', realpath(__DIR__ . '/../../static/'));
# Default ttl of the file-based cache.
# 60 seconds is chosen to avoid stale data, and in case of need, it's configurable when you initiate the CfCache library.
define('CACHE_TIME_IN_SECONDS', 60);

define('MAX_NAME_LENGTH', 100);
define('MAX_VALUE_LENGTH', 16000);
define('MAX_CMDB_NAME_LENGTH', 255);
define('MAX_URL_LENGTH', 2048);

// access token will be marked as 2FA-verified for 5 minutes after the last successful verification
define('TWO_FA_VERIFICATION_EXPIRES_MINUTES', 5);
define('TIME_IN_HOURS_TO_ENABLE_2FA_AFTER_ENFORCEMENT', 48);
