<?php
$css_apps_classes = applicationsIconsToCSS_Stub();
$current_application = getCurrentApplication();
$availableApplications = getAvailableApplications();
?>
<div id="tab-nav">
    <ul class="unstyled">
        <?php
        foreach ($availableApplications as $a)
        {
            // skip menu items if non admin
            if($a['rbac_id'] != null && !isActionAllowed($a['rbac_id'])){
                continue;
            }

            $selected = ($a['id'] == $current_application) ? 'selected' : '';
            ?>

            <li id="<?= htmlspecialchars($a['id']) ?>" class="<?= htmlspecialchars($selected) ?>">
                <?php
                $text = sprintf('<i class="%s"></i><span>%s</span>', $css_apps_classes[$a['id']], $a['meta']['name']);
                echo anchor($a['url'], $text);
                echo getApplicationBadge($a['id']);
                ?>
            </li>
        <?php } ?>
    </ul>
</div>
