<?php

namespace CMDB\v2\Entities;

class CmdbEntryFactory
{
    public static function fromRequest(object $data, string $hostkey): CmdbHostEntry
    {
        $entries = $data->entries ?? [];

        $subentries = array_map(function ($subentry) use ($hostkey): CmdbHostSubEntry {
            return new CmdbHostSubEntry(
                id: null,
                entry_id: null,
                hostkey: $hostkey,
                item_name: $subentry->item_name ?? '',
                item_type: $subentry->item_type ?? '',
                item_value: $subentry->item_value ?? '',
            );
        }, $entries);

        return new CmdbHostEntry(
            id: null,
            hostkey: $hostkey,
            name: $data->name ?? '',
            description: $data->description ?? '',
            tags: (array)($data->tags ?? new \stdClass()),
            type: $data->type ?? '',
            meta: (array)($data->meta ?? new \stdClass()),
            subentries: $subentries
        );
    }
}
