<?php


class SharedGroupCmdb_model extends Cf_Model
{
    private $endpoint = '/host-groups/v2/shared/%d/cmdb';
    private $itemEndpoint = '/host-groups/v2/shared/cmdb';

    private function getUrl($groupId = null): string
    {
        if (!$groupId) {
            return $this->itemEndpoint;
        } else {
            return sprintf($this->endpoint, $groupId);
        }
    }

    public function getItems($groupId, $offset = 0, $limit = 6)
    {
        return json_decode($this->getRestClient()->get($this->getUrl($groupId) . "?skip=$offset&limit=$limit", processBody: false), $associative = false);
    }

    public function updateItem($entryId, $data)
    {
        $this->getRestClient()->put("{$this->getUrl()}/$entryId", $data);
    }

    public function createItem($groupId, $data)
    {
        return $this->getRestClient()->post("{$this->getUrl($groupId)}", $data);
    }

    public function deleteItem($entryId)
    {
        return $this->getRestClient()->delete("{$this->getUrl()}/$entryId/");
    }

    public function getItemByName($groupId, $type, $name)
    {
        return $this->getRestClient()->get("{$this->getUrl($groupId)}/subentry/$type/$name/");
    }

    public function getPolicyConfigurationIds($groupId)
    {
        return $this->getRestClient()->get("{$this->getUrl($groupId)}/policy-configuration-ids");
    }
}
