<?php

class promisesfilter_model extends Cf_Model
{
    private $allowedModes = ['all', 'user', 'system'];
    private $defaultMode = ''; // see constructor

    public function __construct()
    {
        parent::__construct();
        $this->defaultMode = $this->config->item('default_promisesfilter_mode');
    }

    public function checkMode($mode)
    {
        if (!in_array($mode, $this->allowedModes)) {
            return false;
        }

        return true;
    }

    public function getDefaultMode()
    {
        return $this->defaultMode;
    }

    public function validateAndGetMode($mode)
    {
        $mode = empty($mode) ? 'all' : strtolower($mode);

        if ($this->checkMode($mode) === false) {
            $mode = $this->getDefaultMode();
        }

        return $mode;
    }
}
