<?php

class CF_Rule
{
    public $id;
    public $username;
    public $name;
    public $description;
    public $type;
    public $category;
    public $conditionMustBeMet;
    public $severity;
    public $policyConditions;
    // inventory
    public $inventoryConditions;
    public $softwareUpdateConditions;
    public $customConditions;
    public $fileChangedConditions;
    public $hostcontexts;
    public $export_id;

    public function __construct($params = [])
    {
        // common properties
        $this->id = isset($params['id']) ? intval($params['id']) : null;
        $this->username = isset($params['username']) ? $params['username'] : null;
        $this->name = isset($params['name']) ? $params['name'] : null;
        $this->description = isset($params['description']) ? $params['description'] : null;
        $this->type = isset($params['type']) ? $params['type'] : null;
        $this->category = isset($params['category']) ? $params['category'] : 'uncategorized';
        $this->severity = isset($params['severity']) ? $params['severity'] : null;
        $this->conditionMustBeMet = isset($params['conditionmustbemet']) ? $params['conditionmustbemet'] : null;

        //type-based properties

        $this->policyConditions = isset($params['policyconditions'])
            ? json_decode($params['policyconditions'], true)
            : null;

        $this->inventoryConditions = isset($params['inventoryconditions'])
            ? json_decode($params['inventoryconditions'], true)
            : null;

        $this->softwareUpdateConditions = isset($params['softwareupdateconditions'])
            ? json_decode($params['softwareupdateconditions'], true)
            : null;

        $this->customConditions = isset($params['customconditions'])
            ? json_decode($params['customconditions'], true)
            : null;

        $this->fileChangedConditions = isset($params['filechangedconditions'])
            ? json_decode($params['filechangedconditions'], true)
            : null;

        $this->hostcontexts = isset($params['hostcontexts']) ? json_decode($params['hostcontexts'], true) : null;

        $this->export_id = $params['export_id'] ?? null;
    }

    public function getId()
    {
        return $this->id;
    }

    public function getUsername()
    {
        return $this->username;
    }

    public function getName()
    {
        return $this->label;
    }

    public function getDescription()
    {
        return $this->description;
    }

    public function getType()
    {
        return $this->type;
    }

    public function getConditionMustBeMet()
    {
        return $this->conditionMustBeMet;
    }

    public function getPolicyConditions()
    {
        return $this->policyConditions;
    }

    public function getInventoryCondition()
    {
        return $this->inventoryConditions;
    }

    public function getSoftwareUpdateConditions()
    {
        return $this->softwareUpdateConditions;
    }

    public function getCustomConditions()
    {
        return $this->customConditions;
    }

    public function getFileChangedConditions()
    {
        return $this->fileChangedConditions;
    }

    public function getExportId()
    {
        return $this->export_id;
    }
}
