
    <div class="left-column">
        <div class="col-padding">
            <h4 class="bold float-left">Hosts</h4>
            <a class="refresh float-right" href="#" id="navi-tree-refresh"><i class="bi bi-arrow-clockwise"></i>Refresh</a>
            <div class="clearfix"></div>
            <div id="astrolabe"> </div>
            <div id="promisesfilter"></div>
        </div>
    </div>
    <div class="right-column">
        <div class="pageTitle astrolabeLocation">
        </div>

        <div id="vitals" class="margin-bottom">
            <div id="vitalsContainer" class="vitalsContainer">
            </div>
        </div>
    </div>

<script type="text/javascript">
    'use strict'
    var CF = CF || {};

    CF.Plugins= function() {
        var pub = {};

        pub.genericOption = {
            baseUrl: '<?php echo site_url() ?>'
        };

        return pub;

    }();
    CF.Plugins.astrolabeLocation = function() {
        var pub = {}; // public methods and vars
        var $container = $('.astrolabeLocation');
        pub.init = function() {
            var astrolableComplianceOptions = {
                defaultLabel: '',
                defaultHostLabel: ' ',
                defaultContextPathLabel: '',
                defaultHeaderWrapper:'<h1 class="display-inline-block" />'
            };

            $container.astrolabeLocation(astrolableComplianceOptions);
        };


        pub.show = function() {
            $container.show();
        };

        pub.hide = function()  {
            $container.hide();
        };

        pub.setContext = function(args) {
            $container.astrolabeLocation('setContextPath', args.path, args.count);
        };

        pub.setHost = function(args) {
            $container.astrolabeLocation('setHostName', args.hostName);
        }
        return pub;
    }();

    CF.Plugins.astroable = function() {
        var pub = {};
        var $container = $('#astrolabe');
        var currentHOSTKEY = ''
        pub.init = function() {
            $container.astrolabe({
                baseUrl: CF.Plugins.genericOption.baseUrl,

                hostSelected: function(event, args) {
                    if (currentHOSTKEY !== args.hostKey)
                    {
                        currentHOSTKEY = args.hostKey;
                        CF.Plugins.vitalSigns.setHostContext(args);
                        CF.Plugins.astrolabeLocation.setHost(args);
                    }
                },

                nodeSelected: function(event, args) {
                    currentHOSTKEY = '';
                    CF.Plugins.vitalSigns.setContext(args);
                    CF.Plugins.astrolabeLocation.setContext(args);
                }
            });

        };

        pub.refresh = function() {
             $container.astrolabe('refresh');
        };

        return pub;
    }();


    CF.Plugins.vitalSigns = function() {
        var pub = {}; // public methods and vars
        var $container = $('#vitalsContainer');
        pub.init = function() {
            $container.vitalSigns
            ({
                baseUrl: CF.Plugins.genericOption.baseUrl,
                graphclicked: function(e,data) {
                    var options = {'remote':CF.Plugins.genericOption.baseUrl+'/vitals/vital_detail_view/'+data.hostkey +'/'+ data.obs};
                    var dialogBody = {
                        'header':"",
                        'body_url':options.remote,
                        'onEscape': function(){}
                    };
                    $("<div></div>")
                        .dialog_modal({
                            passedArgs: ['',[],dialogBody],
                            css: {
                                'width': function () {
                                    return ($(document).width() * .8) + 'px';
                                },

                                'margin-left': function () {
                                    return -($(this).width() / 2);
                                }
                            },
                            addBodyClass: 'vitalsModal'
                        })
                    $(document).off('focusin.modal');

                    return;
                }
            });
        };

        pub.refresh = function() {
            $container.vitalSigns('refresh');
        }

        pub.show = function() {
            $container.show();
        };

        pub.hide = function()  {
            $container.hide();
        };

        pub.setContext = function(args) {
            $container.vitalSigns('setContext',args.includes, []);
        };

        pub.setHostContext= function(args) {
            $container.vitalSigns('setHostContext',args.hostKey);
        };

        pub.activate = function(flag) {
            $container.vitalSigns('setActiveMode',flag);
        };

        return pub;
    }();


    $(document).ready(function(){

        CF.Plugins.astroable.init();

        CF.Plugins.astrolabeLocation.init();

        CF.Plugins.vitalSigns.init();

        $("#navi-tree-refresh").click(function(){
             CF.Plugins.astroable.refresh();
        });

        const helpEl = document.querySelector('.help');
        if (helpEl) {
            // display help button
            helpEl.style.display = 'contents';
        }
    });
</script>
