<?php

abstract class BaseEventHandler
{
    protected $eventData;
    /**
     * @var eventslog_model $eventsLogModel
     */
    protected $eventsLogModel;

    public const HOST_EVENT_TYPE = 'host';

    public function __construct($eventData)
    {
        $this->eventData = $eventData;
    }

    public function handle()
    {
        $eventEntity = $this->prepareEventEntity(new EventEntity());
        $this->store($eventEntity);
    }

    abstract protected function prepareEventEntity(EventEntity $eventEntity);

    private function store(EventEntity $eventEntity)
    {
        $this->eventsLogModel->save($eventEntity->toArray());
    }

    public function setEventsLogModel($eventsLogModel)
    {
        $this->eventsLogModel = $eventsLogModel;
    }
}
