<?php
require_once APPPATH . 'libraries/Cf_REST_Controller.php';

class Scriptsapi extends Cf_REST_Controller
{
    public function __construct()
    {
        parent::__construct();

        $this->load->model('alerts_model');
        $this->username = $this->session->userdata('username');
    }

    //$rulesIds - can be urlencoded comma separated list
    public function scripts_get($id = null)
    {
        try {
            $result = $this->alerts_model->getAllNotificationScripts($id);
            $json = json_encode($result);
            respond_ok($json);
        } catch (Exception $e) {
            $message = $e->getMessage();
            log_message('debug', 'Failed retrieving scripts, error: ' . $message);
            respond_internal_error($message);
        }
    }
}
