<?php

class SettingsPreferencesExporter extends BaseDataExporter
{
    public function isOnlyForAdmin(): bool
    {
        return true;
    }

    public function getData(): array
    {
        $logoFile = FCPATH . '/public/tmp/pdf_logo.jpg';
        if (file_exists($logoFile)) {
            $this->phar->addFile($logoFile, 'pdf_logo.jpg');
        }

        $settings = $this->settingsDb->query('SELECT * FROM settings')->result_array();
        return ['info' => sizeof($settings), 'data' => json_encode($settings)];
    }
}
