<?php

require_once APPPATH . '/libraries/Cf_REST_Controller.php';
require_once APPPATH . 'modules/advancedreports/services/InventoryAPIService.php';

class PinItem extends Cf_REST_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->username = $this->session->userdata('username');
        $this->load->model('pinned_items_model');
    }

    public function pin_get()
    {
        $hostkey = $this->param('hostkey');

        $data = $this->pinned_items_model->getItemsWithValues(
            $this->username,
            $hostkey,
            new InventoryAPIService($this->getRestClient()),
        );

        respond_ok(json_encode($data));
    }

    public function pin_post()
    {
        $data = $this->param('data');
        $id = $this->pinned_items_model->add($this->username, $data['type'], $data['name']);
        respond_ok(json_encode(['id' => $id]));
    }

    public function pin_delete($id)
    {
        $response = $this->pinned_items_model->delete($this->username, intval($id));
        respond_ok();
    }
}
