#!/usr/bin/env python3
import os
from hashlib import sha256
from urllib.request import Request, urlopen

token_name = "GITLAB_BUILD_REPOSITORY_TOKEN"

print("Checking if token is in environment...")
if token_name not in os.environ:
    print(f"{token_name} is a required environment variable.")
    print("try 'source gitlab-token-from-mystiko.sh'")
    exit(1)

token = os.environ[token_name]
# append a newline so that comparing a value from gnu pass matches this value without a newline
token_to_hash = token + "\n"

digest = sha256(token_to_hash.encode('utf-8')).hexdigest()
print(f"Token sha256 digest: {digest}")

print("Checking if token works with gitlab.com...")
req = Request("https://gitlab.com/api/v4/projects/37228325/access_tokens")
req.add_header("PRIVATE-TOKEN", token)
try:
    content = urlopen(req).read()
    print(content)
except Exception as e:
    print(
        f"""
Failed to use token in {token_name} with gitlab.com
Exception {type(e)}: {e}
---
The token may be expired or incorrect.
The token is managed at:
  https://gitlab.com/Northern.tech/CFEngine/mp-build-testing/-/settings/access_tokens
The token must have api, read_repository and write_repository scopes.
The token must have the role Maintainer
The token should be saved to
  mystiko/developers/CFEngine/GITLAB_BUILD_REPOSITORY_TOKEN
The token must be set as
  GH_ACTIONS_GITLAB_BUILD_REPOSITORY_TOKEN at
  https://github.com/organizations/cfengine/settings/secrets/actions
The token must also be set as a Password Parameter with the name GITLAB_BUILD_REPOSITORY_TOKEN at
  https://ci.cfengine.com/job/testing-run-php-selenium-tests/configure
"""
    )
    exit(1)

print("Environment is OK.")
