<?php
class apps_model extends Cf_Model
{
    public $collectionName = 'app';
    // for modules location see config/config.php

    /**
     * Return all applications which visible on welcome screen and on appswitcher in header, ordered by displayIndex
     *
     *
     * @return <array>
     */
    public function getFrontendApps()
    {
        $filter = [];
        $filter['showappslist'] = 1;
        $filter['state'] = 1;

        $data = [];
        $query = $this->db->where($filter)->order_by('displayindex', 'ASC')->get($this->collectionName);

        foreach ($query->result_array() as $row) {
            $row['meta'] = json_decode($row['meta'], true);
            $data[] = $row;
        }

        return $data;
    }
    /**
     * Update application
     *
     * @param <array> $data
     */
    public function updateApp($data)
    {
        $filter = [];

        if (isset($data['id'])) {
            $filter['id'] = $data['id'];
        }

        if (!empty($data['meta'])) {
            $data['meta'] = json_encode($data['meta']);
        }

        if ($this->db->where($filter)->count_all_results($this->collectionName) == 0) {
            $this->db->insert($this->collectionName, $data);
        } else {
            $this->db->where($filter)->update($this->collectionName, $data);
        }
    }
    /**
     * Get all information about application
     *
     * @param <string> $id -- application id
     * @return <array>
     */
    public function getApplication($id)
    {
        $data = $this->db
            ->where([
                'id' => $id,
            ])
            ->get($this->collectionName);

        return $data->first_row();
    }
    /**
     *  return true is state is on for the given id
     * @param string $id
     * @return boolean
     */
    public function isActive($id)
    {
        $data = $this->getApplication($id);
        if (!empty($data) && is_array($data) && $data['state'] === 1) {
            return true;
        }
        return false;
    }
    /**
     * Delete application from DB
     *
     * @param <string> $id - application id
     * @return <null>
     */
    public function deleteApplication($id)
    {
        $this->db
            ->where([
                'id' => $id,
            ])
            ->delete($this->collectionName);
        return;
    }
    /**
     * Get all the available applications
     *
     * @return <array>
     */
    public function getAllApplication()
    {
        $query = $this->db->order_by('displayindex', 'ASC')->get($this->collectionName);
        $data = [];

        foreach ($query->result_array() as $row) {
            $data[] = $row;
        }
        return $data;
    }
    /**
     * Return enabled apps ids
     *
     * @return <array>
     */
    public function getEnabledApplicationsIds()
    {
        $filter = [];
        $filter['state'] = 1;
        $query = $this->db->where($filter)->get($this->collectionName);

        $apps = [];

        foreach ($query->result_array() as $row) {
            $apps[$row['id']] = $row['id'];
        }

        return $apps;
    }
    /**
     * Read meta information from $meta_file file
     *
     * @param <string> $meta_file - file on file system
     * @param <string> $module - application id
     * @return <array> - application meta info
     */
    public function getAppsMetaData($meta_file, $module)
    {
        $tmp = file_get_contents(realpath($meta_file));
        $json_arr = json_decode($tmp, true);

        if ($json_arr !== null) {
            return $json_arr;
        } else {
            $this->setError("Unable to parse json info for module: $module");
            return false;
        }
    }
    /**
     * Set default info to apps meta
     *
     * @param <string> $module - application id
     */
    public function setAppsDefaultMeta($module)
    {
        $default = [];

        $default['name'] = $module;
        $default['show_apps_list'] = 1;
        $default['has_controller'] = '0';
        $default['icon'] = 'default.png';

        return $default;
    }
}
