<?php
require_once APPPATH . 'libraries/Cf_REST_Controller.php';

class FileIntegrityMonitoring extends Cf_REST_Controller
{
    /** @var null */
    private $username = null;

    public function __construct()
    {
        parent::__construct();
        if (CLI === false) {
            $this->username = $this->session->userdata('username');
        }

        $this->load->model('file_integrity_monitoring_model');
    }

    public function fileList_get()
    {
        $inputs = $_REQUEST;
        $files = $this->file_integrity_monitoring_model->getFilesList(
            $inputs['query'],
            isset($inputs['limit']) ? $inputs['limit'] : null,
        );
        $this->respond_ok(json_encode($files));
    }

    public function convertDiff_post()
    {
        //replace \\ to \ otherwise json_decode will fail
        $diffJson = str_replace('\\\\', '\\', $this->input->post('diff'));
        $diff = json_decode($diffJson, JSON_OBJECT_AS_ARRAY);
        $this->load->library('diffConverters/DiffToHtml');
        $this->load->library('diffConverters/DiffToArray');
        $result = ['html' => $this->difftohtml->convert($diff), 'array' => $this->difftoarray->convert($diff)];
        $this->respond_ok(json_encode($result));
    }
}
