<?php

require_once APPPATH . '/libraries/Cf_REST_Controller.php';

/*
License information controller
*/
class Licenses extends Cf_REST_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('license/license_inventory_model');
        $this->username = $this->session->userdata('username');
        $this->load->library('Setting_lib');
        $this->license_inventory_model->setRestClient($this->ion_auth->getRestClient());
    }

    /*
     * Return info about licenses
     *
     */
    public function status_get()
    {
        $data = [];

        try {
            $licenseDetails = $this->license_inventory_model->getLicenseDetails()->toArray();
            $data = [
                'details' => $licenseDetails,
                'licenseGranted' => isset($licenseDetails['granted']) ? $licenseDetails['granted'] : '',
                'utilized' => isset($licenseDetails['utilized']) ? $licenseDetails['utilized'] : '',
                'licenseOwner' => isset($licenseDetails['owner']) ? $licenseDetails['owner'] : '',
                'licenseType' => isset($licenseDetails['licenseType']) ? $licenseDetails['licenseType'] : '',
                'expiry' => isset($licenseDetails['expires']) ? $licenseDetails['expires'] : '',
            ];
            $this->respond_ok(json_encode($data));
        } catch (Exception $e) {
            log_message(log_level_for_exception($e), 'license error:' . $e->getMessage());
        }
    }
}
