<?php
/**
 * This script gets CFE_ROBOT user credentials and calls CMDB API to get configurations list
 * /var/cfengine/httpd/php/bin/php /var/cfengine/httpd/htdocs/scripts/get_cmdb.php *fromEpoch (int)*
 * Masterfiles are using this script to render host-specific configs
 */
$secretsIniPath = realpath('/var/cfengine/httpd/secrets.ini');
if (file_exists($secretsIniPath)) {
    $secrets = parse_ini_file($secretsIniPath);
} else {
    echo "Secrets ini is not found here '/var/cfengine/httpd/secrets.ini' \n";
    exit(1);
}

if (!isset($argv[1])) {
    echo "`fromEpoch` is required parameter \n";
    exit(1);
}

$auth = base64_encode("CFE_ROBOT:{$secrets['cf_robot_password']}");
$curl = curl_init();

curl_setopt_array($curl, [
    CURLOPT_URL => 'https://localhost/api/cmdb?fromEpoch=' . $argv[1],
    CURLOPT_SSL_VERIFYHOST => 0,
    CURLOPT_SSL_VERIFYPEER => 0,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_RETURNTRANSFER => 1,
    CURLOPT_CUSTOMREQUEST => 'GET',
    CURLOPT_HTTPHEADER => ['Content-Type: application/x-www-form-urlencoded', "Authorization: Basic $auth"],
]);

$response = curl_exec($curl);

curl_close($curl);
echo $response;
exit(0);
