<?php

class Engineering extends Cf_Controller
{
    public function __construct()
    {
        parent::__construct();

        setCurrentApplication('engineering');
    }

    public function index($hostkey = null)
    {
        $this->load->model('host_model');
        $this->username = $this->session->userdata('username');
        $hostFound = $this->host_model->getHostFound($this->username, $hostkey);
        if ($hostFound === false) {
            $this->custom_404();
            return;
        }

        $requiredjs = [['host-page.js']];

        $this->carabiner->js($requiredjs);

        $requiredAngularjs = [
            ['dist/angular-base.bundle.js'],

            ['hostInfo/app.js'],
            ['hostInfo/controllers/hostInfoController.js'],
            ['hubManagement/services/hubManagementService.js'],
            ['common_directives/objectsFilter.js'],

            ['dist/ace-editor.bundle.js'],
        ];

        $this->carabiner->js($requiredAngularjs, $requiredAngularjs, $combine = true, $minify = false);

        $data = [
            'title' => $this->lang->line('mission_portal_title') . ' - ' . $this->lang->line('hosts_app_page_title'),
            'hostkey' => $hostkey,
        ];

        $this->template->load('template', 'engineering', $data);
    }
}
