<?php

class cf_csv
{
    public $header = null;
    public $data = null;
    public $filename = 'temp.csv';

    public function initialize($header = [], $data = [], $filename = null)
    {
        $this->header = $header;
        $this->data = $data;
        $this->filename = $filename !== null ? $filename : $this->filename;
    }

    public function setHeader($header = [])
    {
        $this->header = $header;
    }

    public function setData($data = [])
    {
        $this->data = $data;
    }

    public function setFileName($name = 'sample.csv')
    {
        $this->filename = $name;
    }

    /**
     * function to build the actual csv content from header and data
     * @param string filename
     * @param strind D-Download, F-write to file
     */
    public function Output($filename = null, $flag = 'D')
    {
        $this->filename = $filename !== null ? $filename : $this->filename;

        if (strtoupper($flag) == 'F') {
            $output = fopen($this->filename, 'w');
        } else {
            // output headers so that the file is downloaded rather than displayed
            header('Content-Type: text/csv; charset=utf-8');
            header('Content-Disposition: attachment; filename=' . $this->filename);

            $output = fopen('php://output', 'w');
        }
        if (is_array($this->header) && !empty($this->header)) {
            fputcsv($output, $this->header);
        }

        if (is_array($this->data) && !empty($this->data)) {
            foreach ($this->data as $row) {
                fputcsv($output, $row);
            }
        }

        fclose($output);
    }
}
