<?php

/**
 * Class SlistImplementation
 */
class SlistImplementation implements FormatInventoryFilterInterface
{
    /**
     * @param $value
     * @param $operator
     * @return mixed|string
     */
    public function getValueForWhere($value, $operator, \PDO $pdo)
    {
        switch ($operator) {
            case InventoryLib::MATCHES_OPERATOR:
            case InventoryLib::NOT_MATCH_OPERATOR:
                $value = $pdo->quote("(,\s|^)$value(,|$)");
                break;
            case InventoryLib::CONTAINS_OPERATOR:
            case InventoryLib::NOT_CONTAIN_OPERATOR:
                $value = $pdo->quote("%" . $value . "%");
                break;
            case InventoryLib::IS_REPORTED_OPERATOR:
            case InventoryLib::IS_NOT_REPORTED_OPERATOR:
                $value = null;
                break;
            case InventoryLib::IP_MASK_OPERATOR:
                $value = "{$pdo->quote($value)}::inet";
                break;
        }
        return $value;
    }

}
