<?php
include_once __DIR__ . '/BaseDiffConverter.php';

/**
 * Class DiffToHtml
 */
class DiffToHtml extends BaseDiffConverter
{
    /**
     * @param $diff
     *
     * @return string
     */
    public function convert($diff)
    {
        $diffData = $this->parseDiffData($diff);
        $trs = $this->generateTableRows($diffData);
        return "<table class='diff-table'>$trs</table>";
    }

    /**
     * @param $diffData
     *
     * @return string
     */
    private function generateTableRows($diffData)
    {
        $trs = '';
        foreach ($diffData as $d) {
            $deletionLN = $additionLN = '';

            if ($d['operation'] === '+') {
                $class = 'addition';
                $additionLN = $d['lineNumber'];
            } else {
                $class = 'deletion';
                $deletionLN = $d['lineNumber'];
            }

            $trs .= "<tr>
                       <td class='number number-$class'>$deletionLN</td>
                       <td class='number number-$class'>$additionLN</td>
                       <td class='code code-$class code-marker-cell'>{$d['operation']}</td>
                       <td class='code code-$class'>
                         <span class='code-inner'>" . htmlspecialchars($d['content']) . "</span>
                       </td>
                     </tr>";
        }

        return $trs;
    }
}
