<main class="group-page" ng-if="groupExists">
    <?=  $this->load->view('/partials/top') ?>
    <div>
        <div class="margin-top margin-bottom-small border-bottom border-light group-page_filters" id="variableFilters">
            <div class="inventoryfilter"
                 ui="UI"
                 include-classes="true"
                 sql="SQL"
                 showfilterapplybtn="true"
            >
            </div>

            <div include-exclude-by-hostkey
                 excluded-hosts="SQL.entriesFilter.excludes"
                 included-hosts="SQL.entriesFilter.includes"
                 other-filters-applied="SQL.filters.length>0"
            >
            </div>

            <div class="inline-block margin-top" ng-if="isFiltersChanged">
                <button class="btn btn-secondary" ng-click="cancelFilterChanges()">Cancel</button>
                <button class="btn btn-primary" ng-click="saveGroup()"><i class="bi bi-check"></i> Save changes</button>
            </div>
            <div class=" group-page_filters--clearAll">
                <button class="margin-right-small btn btn-transparent" ng-href="" ng-click="clearAllFilters()">Reset</button>
            </div>
        </div>
    </div>
    <hr/>
    <div class="group-page_statistics">
        <div>
            <div class="flex flex--align_center">
                <h2>Number of hosts</h2>
                <i rel="tooltip" class="bi bi-info-circle-fill" data-title="Status" data="" data-placement="bottom"
                   title=""
                   data-original-title="Hosts in this group can change dynamically as reporting data changes."></i>
            </div>
            <div class="group-page_statistics__numbers">{{ VIEW.rowCount }} hosts</div>
            <div ng-if="VIEW.rowCount" class="group-page_statistics__summary">
                <div>OS: <span ng-repeat="item in os">{{ item }}<span ng-if="!$last">, </span></span></div>
                <div>CFEngine versions: <span ng-repeat="item in versions">{{ item }}<span
                            ng-if="!$last">, </span></span></div>
            </div>
        </div>
        <div ng-if="VIEW.rowCount">
            <div style="height: 155px; width: 450px;" high-charts id="chart_os" config="widget.config"></div>
        </div>
    </div>
    <hr/>
    <div class="horizontal-scroll sql-result-table-wrapper margin-bottom">
        <div class="flex flex-space-between flex--align_center">
            <h2>Hosts</h2> <a class="btn btn-info" ng-click="openInventoryReport()" href="#">Open inventory report</a>
        </div>
        <table id="inventory-table" class="table table-bordered float-left" style="margin-bottom:0">
            <thead>
            <tr>
                <th id="header{{$index}}" class="sort-head" ng-repeat="head in VIEW.tablehead"
                    ng-click="sortReorder(head.nameToSort, $event)">
                    <div style="width:100%; margin-right:32px;position:relative">
                        <span>{{head.name}}</span>
                        <i class="bi " ng-class="{'bi-caret-up-fill':head.sort<0,'bi-caret-down-fill':head.sort>0}"></i>
                        <i class="placeholder-icon icon-reorder"></i>
                    </div>
                </th>
            </tr>
            </thead>
            <tbody tr-rows rowdata="VIEW.rows" tablehead="VIEW.tablehead" replaceNull="true">
            </tbody>
        </table>
    </div>
    <div ng-show="VIEW.rowCount">
        <?php
        $this->load->view('advancedreports/partials/_pagination');
        ?>
    </div>
    <div ng-show="!VIEW.rowCount">
        <h4 class="center">No hosts found</h4>
    </div>
</main>
<div class="flex flex--middle margin-top-large" ng-if="!groupExists">
    <div>
        <?=  $this->load->view('error'); ?>
    </div>
</div>
