'use strict';

const personalGroupController = baseGroupController.extend({
    init: function (
        $scope,
        $q,
        $routeParams,
        $modal,
        $cookies,
        personalGroupsService,
        inventoryFilterService,
        inventoryDataService,
        inventoryService,
        inventoryHelper,
        commonHelper,
        paginationService
    ) {
        this._super(
            $scope,
            $q,
            $routeParams,
            $modal,
            $cookies,
            personalGroupsService,
            inventoryFilterService,
            inventoryDataService,
            inventoryService,
            inventoryHelper,
            commonHelper,
            paginationService
        );


        this.$scope.shared = false;
        this.$scope.type = 'personal';
        this.$scope.tab = 'overview';
        this.$scope.makeShared = this.makeShared.bind(this);
        this.$cookies = $cookies;
    },

    defineListeners: function () {
        let self = this;
        this._super();

    },

    makeShared: function () {
        common.globalSpinner.show();
        this.groupsService.makeShared(this.$scope.groupId).then(
            response => {
                notify.success('Group shared.');
                window.location.href = encodeURI(`/groups/shared/${response.data.id}`);
                common.globalSpinner.hide();
                this.$scope.personalgroup = false;
                this.$cookies.put('grouplist', 'shared', {'path': '/'});
            },
            error => {
                notify.error(error.data);
                this.$scope.shared = false;
                common.globalSpinner.hide();
            }
        )
    }
});

personalGroupController.$inject = [
    '$scope',
    '$q',
    '$routeParams',
    '$modal',
    '$cookies',
    'personalGroupsService',
    'inventoryFilterService',
    'inventoryDataService',
    'inventoryService',
    'inventoryHelper',
    'commonHelper',
    'IEPaginationService'
];


const personalGroupDataController = personalGroupController.extend({
    init: function (
        $scope,
        $q,
        $routeParams,
        $modal,
        $cookies,
        personalGroupsService,
        inventoryFilterService,
        inventoryDataService,
        inventoryService,
        inventoryHelper,
        commonHelper,
        paginationService
    ) {
        this._super(
            $scope,
            $q,
            $routeParams,
            $modal,
            $cookies,
            personalGroupsService,
            inventoryFilterService,
            inventoryDataService,
            inventoryService,
            inventoryHelper,
            commonHelper,
            paginationService
        );

        this.$scope.tab = 'data';
    }
});

personalGroupDataController.$inject = [
    '$scope',
    '$q',
    '$routeParams',
    '$modal',
    '$cookies',
    'personalGroupsService',
    'inventoryFilterService',
    'inventoryDataService',
    'inventoryService',
    'inventoryHelper',
    'commonHelper',
    'IEPaginationService'
];
