<?php
require_once APPPATH . 'models/Entities/CF_Event.php';

class eventslog_model extends Cf_Model
{
    var $collectionName = 'eventslog';

    function __construct()
    {
        parent::__construct();
    }

    function save($data)
    {
        try
        {
            $readOnlyData = $this->db->query('SELECT pg_is_in_recovery() as in_recovery ')->row();
            if ($readOnlyData->in_recovery == true) {
                log_message('debug', 'PostgreSQL is in recovery, skipping insert events');
                return false;
            }

            $data['tags'] = PhpArrayToPgsql($data['tags']);
            $data['time'] = date("Y-m-d H:i:s", $data['time']);
            $this->db->insert($this->collectionName, $data);

            $id = $this->db->insert_id();
            log_message('debug', 'Event created, id: '. $id);
        }
        catch(Exception $e)
        {
            $message = $e->getMessage();
            log_message('error', 'Unable to save event. Error: ' . $message);
            throw new Exception($message);
        }
        return $id;
    }

    function get_all_events($filter = array() , $offset = '', $limit = '', $order = array())
    {
        if (!empty($limit))
        {
            $this->db->limit($limit, $offset);
        }

        if (!empty($order))
        {
            reset($order);
            $field = key($order);
            $orderValue = current($order);
            $this->db->order_by($field, $orderValue);
        }

        $select = 'id, username, item_id, item_type, item_name, tags, extract(epoch from "time") as time, severity,message,status';

        $query = $this->db->where($filter)->select($select)->get($this->collectionName);

        $data = $query->result_array();
        $result = array();

        foreach ((array)$data as $items)
        {
            $obj = new CF_Event($items);
            $result[] = $obj;
        }

        return $result;
    }

    public function getEventTypes($filter = ''){
        $query = $this->db
            ->select('DISTINCT item_type as type')
            ->where($filter)
            ->get($this->collectionName);

        return $query->result_array();
    }

    /*
     * To be used with new dashboards - only get events for selection of alerts that belong in the current selected dashboard
     */
    function get_selected_events($filter = array() , $offset = '', $limit = '', $order = array())
    {
        if (!empty($limit))
        {
            $this->db->limit($limit, $offset);
        }

        if (!empty($order))
        {
            reset($order);
            $field = key($order);
            $orderValue = current($order);
            $this->db->order_by($field, $orderValue);
        }


        $select = 'id, username, item_id, item_type, item_name, tags, extract(epoch from "time") as time, severity,message,status';

        $query = $this->db
            ->where($filter, NULL, FALSE)
            ->select($select)
            ->get($this->collectionName);

        $data = $query->result_array();
        $result = array();


        foreach ((array)$data as $items)
        {
            $obj = new CF_Event($items);
            $result[] = $obj;
        }

        return $result;
    }

    function get_events_count($filter)
    {
        $this->db->where($filter);
        $this->db->from($this->collectionName);
        return $this->db->count_all_results();
    }

    function delete($filter)
    {
        if (empty($filter))
        {
            $message = "events->delete(). Filter should not be empty";
            log_message('error', 'Unable to delete event. Error: ' . $message);
            throw new Exception($message);
        }

        try
        {
            $return = $this->db->where($filter)->delete($this->collectionName);
            log_message('debug', 'Event deleted');
        }
        catch (Exception $e) {
            $message = $e->getMessage();
            log_message('error', 'Unable to delete event. Error: ' . $message);
            throw new Exception($message);
        }

        return $return;
    }
}
?>