<main>
    <div>
        <div class="pageTitle">
            <h1>
                <span>Compliance reports</span>
            </h1>
        </div>
        <section>
            <button class="btn btn-primary btn-large"
                    ng-click="createReport()">
                <i style="color:white" class="icon-list-alt"></i> Create a report
            </button>

            <button class="btn btn-large"
                    ng-click="import()">
                <i class="bi bi-upload"></i> Import a report
            </button>

            <button class="btn btn-large"
                    ng-click="editConditions()">
                <i class="icon-edit"></i> Edit conditions
            </button>

            <div class="margin-top-large">
                <h3>Saved reports</h3>
                <div class="muted">
                    <span>Show only my reports</span>
                    <div class="checkbox-switch inline-block margin-left">
                        <input id="ownReports" ng-model="ownReports" type="checkbox"/>
                        <label for="ownReports" class="label-success"></label>
                    </div>
                </div>
            </div>

            <div class="margin-top">
                <div class="alert alert-warning" ng-show="!savedReports.length">
                    There are no saved compliance reports
                </div>
                <div ng-show="savedReports.length > 0">
                    <?php $this->load->view('advancedreports/partials/_pagination'); ?>
                    <table class="table table-horizontal listReports_SE margin-top float-left fixed">
                        <thead>
                        <tr>
                            <th class="sort-head" ng-click="sortReorder('username_0', $event)">Author
                                <i ng-class="{'icon-chevron-up':VIEW.tablehead['username_0'].sort<0,'icon-chevron-down':VIEW.tablehead['username_0'].sort>0}"></i>
                            </th>
                            <th>Schedules</th>
                            <th class="sort-head fill" ng-click="sortReorder('label_1', $event)">Name
                                <i ng-class="{'icon-chevron-up':VIEW.tablehead['label_1'].sort<0,'icon-chevron-down':VIEW.tablehead['label_1'].sort>0}"></i>
                            </th>
                            <th>Last compliance score</th>
                            <th class="actions right">Actions</th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr ng-repeat="(rowid, row) in savedReports" testforlast>
                            <td ng-bind-html="getUserName(row) | safe_html"></td>
                            <td>
                                <span ng-show="row.hasSchedules == 1">
                                    <i class="icon-time no-hover"></i>
                                </span>
                                <span ng-show="row.showScheduleStatistic==1">
                                    (<span style="color: green">{{row.ownSchedules}}</span>/{{row.totalSchedules}})
                                </span>
                                <span ng-show="row.showScheduleStatistic== false && row.hasSchedules==1 && row.ownSchedules>0">
                                    {{row.ownSchedules}}
                                </span>
                            </td>
                            <td class="">
                                <a ng-href="compliance/run/{{row.id}}">{{row.label}}</a>
                            </td>
                            <td class="no-wrap"><span class="badge badge-{{complianceHelper.getColorClass(row.score)}}">{{row.score}}%
                            </td>
                            <td class="actions no-wrap right">
                                <a ng-href="report/schedule/{{row.id}}"
                                   ng-click="$event.stopPropagation()">Schedule</a>
                                <a ng-show="row.readonly!=1 && row.can_edit == 1"
                                   ng-href="compliance/edit/{{row.id}}" ng-click="$event.stopPropagation()"
                                   href="javascript:void(0)">Edit</a>
                                <a ng-show="row.readonly!=1 && row.can_delete==1" ng-click="deleteConfirm(row.id)"
                                   href="javascript:void(0)">Remove</a>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                    <?php $this->load->view('advancedreports/partials/_pagination'); ?>
                </div>
            </div>
        </section>
    </div>
</main>
<script type="text/javascript">
    function addUserLabelClass() {
        //if current logged in user, match the username to label tag to change style
        var username = '<?= htmlspecialchars($this->session->userdata('username')) ?>';
        if (username) $('.' + username).addClass('label-warning');
    }
</script>

<script type="text/ng-template" id="deleteConfirm.html">

    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal"  ng-click="close()"><i class="bi bi-x"></i></button>
        <h2>Remove report</h2>
    </div>
    <div class="modal-body">
        <p>
            Are you sure you want to permanently remove this report?
        </p>
    </div>
    <div class="modal-footer">
        <button class="btn btn-large" data-dismiss="modal" ng-click="close()">Cancel</button>
        <button id="remove_report" class="btn btn-large btn-primary btn-danger" data-dismiss="modal"
                ng-click="deleteReport(selectedReport)" >Remove
        </button>
    </div>
</script>
