import React, { useMemo } from 'react';
import { Box, Typography } from '@mui/material';

import { CmdbItem } from '../../../store/cmdbSlice/thunks';
import { VARIABLE_VALUES_TYPES } from './Create';
import { getFirstEntryValue, getFirstEntryName } from '../../../utils';

const getItemType = (value: any): string => {
  if (typeof value === "string" || value === null) {
    return 'string';
  } else if (Array.isArray(value)) {
    return 'list';
  } else if (typeof value === 'object') {
    return 'data';
  }
  return 'string';
};
interface VariableViewProps {
  item: CmdbItem;
  onValueClick?: () => void;
  classes?: Record<string, string>;
}

const VariableView: React.FC<VariableViewProps> = ({ 
  item, 
  onValueClick = () => {}, 
  classes = {} 
}) => {
  const selectedType = useMemo(() => {
    const variableType = item?.meta?.variableType ?? getItemType(getFirstEntryValue(item));
    return VARIABLE_VALUES_TYPES.find(type => type.value === variableType);
  }, [item]);

  const ViewValue = useMemo(() => {
    if (!selectedType) return null;
    return selectedType.viewValueComponent({ value: getFirstEntryValue(item) });
  }, [selectedType, item]);

  return (
    <>
      <Box className={classes.container}>
        <Typography className={classes.key}>
          Name:
        </Typography>
        <Box onClick={onValueClick} className={classes.value}>
          {getFirstEntryName(item)}
        </Box>
      </Box>
      <Box className={classes.container}>
        <Typography className={classes.key}>
          Value:
        </Typography>
        <Box onClick={onValueClick} className={classes.value}>
          {ViewValue}
        </Box>
      </Box>
      <Box className={classes.container}>
        <Typography className={classes.key}>
          Tags:
        </Typography>
        <Box onClick={onValueClick} className={classes.value}>
          {item.tags?.join(', ')}
        </Box>
      </Box>
      <Box className={classes.container}>
        <Typography className={classes.key}>
          Description:
        </Typography>
        <Box onClick={onValueClick} className={classes.value}>
          {item.description}
        </Box>
      </Box>
    </>
  );
};

export default VariableView;
