<?php
class high_availability_model extends Cf_Model
{
    /**
     * Returns info about host which have some variables for high availability set
     *
     * @param type $username
     * @return type
     * @throws Exception
     */
    public function getHAstatus($username)
    {
        try {
            $this->load->model('advancedreports_model');

            $SQL = "SELECT Hosts.HostKey,
                           Hosts.HostName,
                           Hosts.IPAddress,
                           Hosts.LastReportTimeStamp,
                           v1.VariableValue AS hub_node_status
                    FROM Hosts
                        INNER JOIN Variables v1 ON v1.HostKey = Hosts.HostKey
                    WHERE v1.VariableName = 'ha_node_status'";

            $data = $this->advancedreports_model->runQuery($username, $SQL, '', '', 0, 0, [], []);

            return $data['rows'];
        } catch (Exception $e) {
            throw $e;
        }
    }
}
