<?php
include_once FCPATH . 'application/libraries/Cf_tcpdf.php';

class PdfComplianceReports_model extends Cf_Model
{
    private $outputPath;
    private $outputFilePath;
    private $fileName;
    private $complianceData;
    private $reportTitle;
    private $reportDescription;
    private $currentY;
    private $pdf;

    public function __construct()
    {
        parent::__construct();
        $this->outputPath = realpath(get_tmpdir());
    }

    public function generateReport(array $data)
    {
        [$this->fileName, $this->complianceData, $this->reportTitle, $this->reportDescription] = $data;

        !is_array($this->complianceData) &&
            ($this->complianceData = json_decode($this->complianceData, JSON_OBJECT_AS_ARRAY));

        $this->outputFilePath = "{$this->outputPath}/{$this->fileName}.pdf";

        $this->initPdf();
        $this->writeStatus('0');
        $this->pdf->SetFont($family = 'redhattext');
        $this->pdf->printHeader($this->reportTitle, $this->reportDescription);
        $this->printCharts();
        $this->printBody();
        $this->savePDF();
        $this->writeStatus('100');
    }

    private function writeStatus($status)
    {
        file_put_contents("{$this->outputFilePath}.status", $status);
    }

    private function initPdf()
    {
        $this->pdf = new cf_tcpdf(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $this->pdf->SetTitle($this->reportTitle);
        $this->pdf->SetSubject($this->reportDescription);
        $this->pdf->SetPrintHeader(false);
        $this->pdf->AddPage();
    }

    private function printCharts()
    {
        $this->currentY = $this->pdf->getY();
        $this->pdf->writeHTML(
            '<span style="font-weight: 500;font-size: 14px;line-height: 20px;color: #052569;">Overview</span>',
        );
        $lineY = $this->pdf->getY() + $this->pdf->pixelsToMM(10);
        $this->pdf->Line($this->pdf->getX(), $lineY, $this->pdf->getX() + $this->pdf->pixelsToMM(40), $lineY, [
            'width' => 0.1,
            'color' => [5, 37, 105],
        ]);
        $this->currentY += $this->pdf->pixelsToMM(56);
        $this->pdf->setY($this->currentY);

        if (isset($this->complianceData['charts']) && !empty($this->complianceData['charts'])) {
            isset($this->complianceData['charts']['overall']) &&
                $this->pdf->ImageSVG('@' . $this->complianceData['charts']['overall'], $x = 0, $this->currentY, 80, 60);

            isset($this->complianceData['charts']['categories']) &&
                $this->pdf->ImageSVG(
                    '@' . $this->complianceData['charts']['categories'],
                    $x = 80,
                    $this->currentY,
                    120,
                    60,
                );
            $this->currentY += 70;
        }

        $this->pdf->SetXY(10, $this->currentY);
    }

    private function printBody()
    {
        $this->pdf->SetFont($family = 'redhattext');
        $this->pdf->writeHTML(
            '<span style="font-weight: 500;font-size: 14px;line-height: 20px;color: #052569;">Checklist</span>',
        );
        $lineY = $this->pdf->getY() + $this->pdf->pixelsToMM(10);
        $this->pdf->Line($this->pdf->getX(), $lineY, $this->pdf->getX() + $this->pdf->pixelsToMM(40), $lineY, [
            'width' => 0.1,
            'color' => [5, 37, 105],
        ]);
        $html = $this->load->view('advancedreports/partials/compliance_report/export', $this->complianceData, true);
        $this->pdf->writeHTML($html);
    }

    private function savePDF()
    {
        $this->pdf->lastPage();
        $this->pdf->Output($this->outputFilePath, 'F');
    }
}
